/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.grpc.xds.FaultFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.Filter;
import net.snowflake.client.jdbc.internal.grpc.xds.RbacFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.RouterFilter;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

final class FilterRegistry {
    private static FilterRegistry instance;
    private final Map<String, Filter> supportedFilters = new HashMap<String, Filter>();

    private FilterRegistry() {
    }

    static synchronized FilterRegistry getDefaultRegistry() {
        if (instance == null) {
            instance = FilterRegistry.newRegistry().register(FaultFilter.INSTANCE, RouterFilter.INSTANCE, RbacFilter.INSTANCE);
        }
        return instance;
    }

    @VisibleForTesting
    static FilterRegistry newRegistry() {
        return new FilterRegistry();
    }

    @VisibleForTesting
    FilterRegistry register(Filter ... filters) {
        for (Filter filter : filters) {
            for (String typeUrl : filter.typeUrls()) {
                this.supportedFilters.put(typeUrl, filter);
            }
        }
        return this;
    }

    @Nullable
    Filter get(String typeUrl) {
        return this.supportedFilters.get(typeUrl);
    }
}

