/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.ConnectivityState;
import net.snowflake.client.jdbc.internal.grpc.InternalLogId;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.SynchronizationContext;
import net.snowflake.client.jdbc.internal.grpc.util.GracefulSwitchLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.util.MultiChildLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterManagerLoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsNameResolver;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsLogger;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

class ClusterManagerLoadBalancer
extends MultiChildLoadBalancer {
    @VisibleForTesting
    public static final int DELAYED_CHILD_DELETION_TIME_MINUTES = 15;
    protected final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final XdsLogger logger;
    private LoadBalancer.ResolvedAddresses lastResolvedAddresses;

    ClusterManagerLoadBalancer(LoadBalancer.Helper helper) {
        super(helper);
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.timeService = Preconditions.checkNotNull(helper.getScheduledExecutorService(), "timeService");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("cluster_manager-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    @Override
    protected MultiChildLoadBalancer.ChildLbState createChildLbState(Object key) {
        return new ClusterManagerLbState(key, GracefulSwitchLoadBalancerFactory.INSTANCE);
    }

    @Override
    protected Map<Object, LoadBalancer.ResolvedAddresses> createChildAddressesMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.lastResolvedAddresses = resolvedAddresses;
        ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        HashMap<Object, LoadBalancer.ResolvedAddresses> childAddresses = new HashMap<Object, LoadBalancer.ResolvedAddresses>();
        for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
            ClusterManagerLbState state = (ClusterManagerLbState)childLbState;
            if (config.childPolicies.containsKey(state.getKey())) {
                if (state.deletionTimer == null) continue;
                state.reactivateChild();
                continue;
            }
            if (state.deletionTimer == null) {
                state.deactivateChild();
            }
            if (!state.deletionTimer.isPending()) continue;
            childAddresses.put(state.getKey(), null);
        }
        for (Map.Entry entry : config.childPolicies.entrySet()) {
            LoadBalancer.ResolvedAddresses addresses = resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(entry.getValue()).build();
            childAddresses.put(entry.getKey(), addresses);
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster_manager lb config: child names={0}", config.childPolicies.keySet());
        return childAddresses;
    }

    @Override
    protected void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        HashMap<Object, LoadBalancer.SubchannelPicker> childPickers = new HashMap<Object, LoadBalancer.SubchannelPicker>();
        for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
            if (((ClusterManagerLbState)childLbState).deletionTimer != null) continue;
            childPickers.put(childLbState.getKey(), childLbState.getCurrentPicker());
            overallState = ClusterManagerLoadBalancer.aggregateState(overallState, childLbState.getCurrentState());
        }
        if (overallState != null) {
            this.getHelper().updateBalancingState(overallState, this.getSubchannelPicker(childPickers));
            this.currentConnectivityState = overallState;
        }
    }

    protected LoadBalancer.SubchannelPicker getSubchannelPicker(final Map<Object, LoadBalancer.SubchannelPicker> childPickers) {
        return new LoadBalancer.SubchannelPicker(){

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                String clusterName = args.getCallOptions().getOption(XdsNameResolver.CLUSTER_SELECTION_KEY);
                LoadBalancer.SubchannelPicker childPicker = (LoadBalancer.SubchannelPicker)childPickers.get(clusterName);
                if (childPicker == null) {
                    return LoadBalancer.PickResult.withError(Status.UNAVAILABLE.withDescription("CDS encountered error: unable to find available subchannel for cluster " + clusterName));
                }
                return childPicker.pickSubchannel(args);
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("pickers", childPickers).toString();
            }
        };
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        boolean gotoTransientFailure = true;
        for (MultiChildLoadBalancer.ChildLbState state : this.getChildLbStates()) {
            if (((ClusterManagerLbState)state).deletionTimer != null) continue;
            gotoTransientFailure = false;
            state.getLb().handleNameResolutionError(error);
        }
        if (gotoTransientFailure) {
            this.getHelper().updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
        }
    }

    static final class GracefulSwitchLoadBalancerFactory
    extends LoadBalancer.Factory {
        static final LoadBalancer.Factory INSTANCE = new GracefulSwitchLoadBalancerFactory();

        GracefulSwitchLoadBalancerFactory() {
        }

        @Override
        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new GracefulSwitchLoadBalancer(helper);
        }
    }

    private class ClusterManagerLbState
    extends MultiChildLoadBalancer.ChildLbState {
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;

        public ClusterManagerLbState(Object key, LoadBalancer.Factory policyFactory) {
            super(key, policyFactory);
        }

        @Override
        protected MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper createChildHelper() {
            return new ClusterManagerChildHelper();
        }

        @Override
        protected void shutdown() {
            if (this.deletionTimer != null) {
                this.deletionTimer.cancel();
                this.deletionTimer = null;
            }
            super.shutdown();
        }

        void reactivateChild() {
            assert (this.deletionTimer != null);
            this.deletionTimer.cancel();
            this.deletionTimer = null;
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} reactivated", this.getKey());
        }

        void deactivateChild() {
            assert (this.deletionTimer == null);
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ClusterManagerLoadBalancer.this.acceptResolvedAddresses(ClusterManagerLoadBalancer.this.lastResolvedAddresses);
                }
            }
            this.deletionTimer = ClusterManagerLoadBalancer.this.syncContext.schedule(new DeletionTask(), 15L, TimeUnit.MINUTES, ClusterManagerLoadBalancer.this.timeService);
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} deactivated", this.getKey());
        }

        private class ClusterManagerChildHelper
        extends MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper {
            private ClusterManagerChildHelper() {
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (ClusterManagerLbState.this.getCurrentState() == ConnectivityState.SHUTDOWN) {
                    return;
                }
                ClusterManagerLbState.this.setCurrentState(newState);
                ClusterManagerLbState.this.setCurrentPicker(newPicker);
                if (ClusterManagerLbState.this.deletionTimer == null && !ClusterManagerLoadBalancer.this.resolvingAddresses) {
                    ClusterManagerLoadBalancer.this.updateOverallBalancingState();
                }
            }
        }
    }
}

