/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.alts.internal;

import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.AltsContext;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.HandshakerResult;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.RpcProtocolVersions;
import net.snowflake.client.jdbc.internal.grpc.alts.internal.SecurityLevel;

public final class AltsInternalContext {
    final AltsContext context;

    public AltsInternalContext(HandshakerResult result) {
        this.context = AltsContext.newBuilder().setApplicationProtocol(result.getApplicationProtocol()).setRecordProtocol(result.getRecordProtocol()).setSecurityLevel(SecurityLevel.INTEGRITY_AND_PRIVACY).setPeerServiceAccount(result.getPeerIdentity().getServiceAccount()).setLocalServiceAccount(result.getLocalIdentity().getServiceAccount()).setPeerRpcVersions(result.getPeerRpcVersions()).putAllPeerAttributes(result.getPeerIdentity().getAttributesMap()).build();
    }

    @VisibleForTesting
    public static AltsInternalContext getDefaultInstance() {
        return new AltsInternalContext(HandshakerResult.newBuilder().build());
    }

    public String getApplicationProtocol() {
        return this.context.getApplicationProtocol();
    }

    public String getRecordProtocol() {
        return this.context.getRecordProtocol();
    }

    public SecurityLevel getSecurityLevel() {
        return this.context.getSecurityLevel();
    }

    public String getPeerServiceAccount() {
        return this.context.getPeerServiceAccount();
    }

    public String getLocalServiceAccount() {
        return this.context.getLocalServiceAccount();
    }

    public RpcProtocolVersions getPeerRpcVersions() {
        return this.context.getPeerRpcVersions();
    }

    public Map<String, String> getPeerAttributes() {
        return this.context.getPeerAttributesMap();
    }
}

