/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.grpc;

import java.util.UUID;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracer;
import net.snowflake.client.jdbc.internal.grpc.CallOptions;
import net.snowflake.client.jdbc.internal.grpc.Channel;
import net.snowflake.client.jdbc.internal.grpc.ClientCall;
import net.snowflake.client.jdbc.internal.grpc.ClientInterceptor;
import net.snowflake.client.jdbc.internal.grpc.MethodDescriptor;

class GrpcChannelUUIDInterceptor
implements ClientInterceptor {
    private final String uuid = UUID.randomUUID().toString();

    GrpcChannelUUIDInterceptor() {
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        ApiTracer apiTracer = callOptions.getOption(GrpcCallContext.TRACER_KEY);
        if (apiTracer != null) {
            apiTracer.connectionSelected(this.uuid);
        }
        return channel.newCall(methodDescriptor, callOptions);
    }
}

