/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.tika.pipes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.tika.config.TikaConfig;
import net.snowflake.client.jdbc.internal.apache.tika.exception.TikaException;
import net.snowflake.client.jdbc.internal.apache.tika.log.TikaLogger;
import net.snowflake.client.jdbc.internal.apache.tika.log.TikaLoggerFactory;
import net.snowflake.client.jdbc.internal.apache.tika.metadata.Metadata;
import net.snowflake.client.jdbc.internal.apache.tika.metadata.TikaCoreProperties;
import net.snowflake.client.jdbc.internal.apache.tika.parser.AutoDetectParser;
import net.snowflake.client.jdbc.internal.apache.tika.parser.Parser;
import net.snowflake.client.jdbc.internal.apache.tika.parser.RecursiveParserWrapper;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.FetchEmitTuple;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.HandlerConfig;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.emitter.EmitData;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.emitter.EmitKey;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.emitter.Emitter;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.emitter.EmitterManager;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.emitter.TikaEmitterException;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.fetcher.FetchKey;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.fetcher.Fetcher;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.fetcher.FetcherManager;
import net.snowflake.client.jdbc.internal.apache.tika.pipes.fetcher.RangeFetcher;
import net.snowflake.client.jdbc.internal.apache.tika.utils.ExceptionUtils;
import net.snowflake.client.jdbc.internal.apache.tika.utils.StringUtils;
import org.xml.sax.SAXException;

public class PipesServer
implements Runnable {
    private static final TikaLogger LOG = TikaLoggerFactory.getLogger(PipesServer.class);
    public static final int TIMEOUT_EXIT_CODE = 17;
    private final Object[] lock = new Object[0];
    private long checkForTimeoutMs = 1000L;
    private final Path tikaConfigPath;
    private final DataInputStream input;
    private final DataOutputStream output;
    private final long maxForEmitBatchBytes;
    private final long serverParseTimeoutMillis;
    private final long serverWaitTimeoutMillis;
    private Parser autoDetectParser;
    private Parser rMetaParser;
    private TikaConfig tikaConfig;
    private FetcherManager fetcherManager;
    private EmitterManager emitterManager;
    private volatile boolean parsing;
    private volatile long since;

    public PipesServer(Path tikaConfigPath, InputStream in, PrintStream out, long maxForEmitBatchBytes, long serverParseTimeoutMillis, long serverWaitTimeoutMillis) throws IOException, TikaException, SAXException {
        this.tikaConfigPath = tikaConfigPath;
        this.input = new DataInputStream(in);
        this.output = new DataOutputStream(out);
        this.maxForEmitBatchBytes = maxForEmitBatchBytes;
        this.serverParseTimeoutMillis = serverParseTimeoutMillis;
        this.serverWaitTimeoutMillis = serverWaitTimeoutMillis;
        this.parsing = false;
        this.since = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            Path tikaConfig = Paths.get(args[0], new String[0]);
            long maxForEmitBatchBytes = Long.parseLong(args[1]);
            long serverParseTimeoutMillis = Long.parseLong(args[2]);
            long serverWaitTimeoutMillis = Long.parseLong(args[3]);
            PipesServer server = new PipesServer(tikaConfig, System.in, System.out, maxForEmitBatchBytes, serverParseTimeoutMillis, serverWaitTimeoutMillis);
            System.setIn(new ByteArrayInputStream(new byte[0]));
            System.setOut(System.err);
            Thread watchdog = new Thread((Runnable)server, "Tika Watchdog");
            watchdog.setDaemon(true);
            watchdog.start();
            server.processRequests();
        }
        finally {
            LOG.info("server shutting down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                Object[] objectArray = this.lock;
                // MONITORENTER : this.lock
                long elapsed = System.currentTimeMillis() - this.since;
                if (this.parsing && elapsed > this.serverParseTimeoutMillis) {
                    LOG.warn("timeout server; elapsed {}  with {}", elapsed, this.serverParseTimeoutMillis);
                    this.exit(17);
                } else if (!this.parsing && this.serverWaitTimeoutMillis > 0L && elapsed > this.serverWaitTimeoutMillis) {
                    LOG.info("closing down from inactivity");
                    this.exit(0);
                }
                // MONITOREXIT : objectArray
                Thread.sleep(this.checkForTimeoutMs);
            }
        }
        catch (InterruptedException e) {
            LOG.debug("interrupted");
            return;
        }
    }

    public void processRequests() {
        long start;
        LOG.debug("processing requests {}");
        try {
            start = System.currentTimeMillis();
            this.initializeParser();
            if (LOG.isTraceEnabled()) {
                LOG.trace("timer -- initialize parser: {} ms", System.currentTimeMillis() - start);
            }
            LOG.debug("pipes server initialized");
        }
        catch (Throwable t2) {
            LOG.error("couldn't initialize parser", t2);
            try {
                this.output.writeByte(STATUS.FAILED_TO_START.getByte());
                this.output.flush();
            }
            catch (IOException e) {
                LOG.warn("couldn't notify of failure to start", e);
            }
            return;
        }
        try {
            this.write(STATUS.READY);
            start = System.currentTimeMillis();
            while (true) {
                int request;
                if ((request = this.input.read()) == -1) {
                    LOG.warn("received -1 from client; shutting down");
                    this.exit(1);
                } else if (request == STATUS.PING.getByte()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("timer -- ping: {} ms", System.currentTimeMillis() - start);
                    }
                    this.write(STATUS.PING);
                    start = System.currentTimeMillis();
                } else if (request == STATUS.CALL.getByte()) {
                    this.parseOne();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("timer -- parse one: {} ms", System.currentTimeMillis() - start);
                    }
                    start = System.currentTimeMillis();
                } else {
                    throw new IllegalStateException("Unexpected request");
                }
                this.output.flush();
            }
        }
        catch (Throwable t3) {
            LOG.error("main loop error (did the forking process shut down?)", t3);
            this.exit(1);
            System.err.flush();
            return;
        }
    }

    private boolean metadataIsEmpty(List<Metadata> metadataList) {
        return metadataList == null || metadataList.size() == 0;
    }

    private String getContainerStacktrace(FetchEmitTuple t2, List<Metadata> metadataList) {
        if (metadataList == null || metadataList.size() < 1) {
            return "";
        }
        String stack = metadataList.get(0).get(TikaCoreProperties.CONTAINER_EXCEPTION);
        return stack != null ? stack : "";
    }

    private void emit(String taskId, EmitData emitData, String parseExceptionStack) {
        Emitter emitter = null;
        try {
            emitter = this.emitterManager.getEmitter(emitData.getEmitKey().getEmitterName());
        }
        catch (IllegalArgumentException e) {
            String noEmitterMsg = this.getNoEmitterMsg(taskId);
            LOG.warn(noEmitterMsg);
            this.write(STATUS.EMITTER_NOT_FOUND, noEmitterMsg);
            return;
        }
        try {
            emitter.emit(emitData.getEmitKey().getEmitKey(), emitData.getMetadataList());
        }
        catch (IOException | TikaEmitterException e) {
            LOG.warn("emit exception", e);
            String msg = ExceptionUtils.getStackTrace(e);
            byte[] bytes = msg.getBytes(StandardCharsets.UTF_8);
            this.write(STATUS.EMIT_EXCEPTION, bytes);
            return;
        }
        if (StringUtils.isBlank(parseExceptionStack)) {
            this.write(STATUS.EMIT_SUCCESS);
        } else {
            this.write(STATUS.EMIT_SUCCESS_PARSE_EXCEPTION, parseExceptionStack.getBytes(StandardCharsets.UTF_8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseOne() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.parsing = true;
            this.since = System.currentTimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            FetchEmitTuple t2 = null;
            try {
                long start = System.currentTimeMillis();
                t2 = this.readFetchEmitTuple();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("timer -- read fetchEmitTuple: {} ms", System.currentTimeMillis() - start);
                }
                start = System.currentTimeMillis();
                this.actuallyParse(t2);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("timer -- actually parsed: {} ms", System.currentTimeMillis() - start);
                }
            }
            catch (OutOfMemoryError e) {
                this.handleOOM(t2.getId(), e);
            }
            finally {
                Object[] objectArray2 = this.lock;
                synchronized (this.lock) {
                    this.parsing = false;
                    this.since = System.currentTimeMillis();
                    // ** MonitorExit[var2_6] (shouldn't be in output)
                }
            }
            return;
        }
    }

    private void actuallyParse(FetchEmitTuple t2) {
        long start = System.currentTimeMillis();
        Fetcher fetcher = this.getFetcher(t2);
        if (fetcher == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            LOG.trace("timer -- got fetcher: {}ms", elapsed);
        }
        start = System.currentTimeMillis();
        List<Metadata> metadataList = this.parseIt(t2, fetcher);
        if (LOG.isTraceEnabled()) {
            LOG.trace("timer -- to parse: {} ms", System.currentTimeMillis() - start);
        }
        if (this.metadataIsEmpty(metadataList)) {
            this.write(STATUS.EMPTY_OUTPUT);
            return;
        }
        this.emitIt(t2, metadataList);
    }

    private void emitIt(FetchEmitTuple t2, List<Metadata> metadataList) {
        long start = System.currentTimeMillis();
        String stack = this.getContainerStacktrace(t2, metadataList);
        if (StringUtils.isBlank(stack) || t2.getOnParseException() == FetchEmitTuple.ON_PARSE_EXCEPTION.EMIT) {
            this.injectUserMetadata(t2.getMetadata(), metadataList);
            EmitKey emitKey = t2.getEmitKey();
            if (StringUtils.isBlank(emitKey.getEmitKey())) {
                emitKey = new EmitKey(emitKey.getEmitterName(), t2.getFetchKey().getFetchKey());
                t2.setEmitKey(emitKey);
            }
            EmitData emitData = new EmitData(t2.getEmitKey(), metadataList);
            if (this.maxForEmitBatchBytes >= 0L && emitData.getEstimatedSizeBytes() >= this.maxForEmitBatchBytes) {
                this.emit(t2.getId(), emitData, stack);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("timer -- emitted: {} ms", System.currentTimeMillis() - start);
                }
            } else {
                this.write(emitData);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("timer -- to write data: {} ms", System.currentTimeMillis() - start);
                }
            }
        } else {
            this.write(STATUS.PARSE_EXCEPTION_NO_EMIT, stack);
        }
    }

    private Fetcher getFetcher(FetchEmitTuple t2) {
        try {
            return this.fetcherManager.getFetcher(t2.getFetchKey().getFetcherName());
        }
        catch (IllegalArgumentException e) {
            String noFetcherMsg = this.getNoFetcherMsg(t2.getFetchKey().getFetcherName());
            LOG.warn(noFetcherMsg);
            this.write(STATUS.FETCHER_NOT_FOUND, noFetcherMsg);
            return null;
        }
        catch (IOException | TikaException e) {
            LOG.warn("Couldn't initialize fetcher for fetch id '" + t2.getId() + "'", e);
            this.write(STATUS.FETCHER_INITIALIZATION_EXCEPTION, ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    private List<Metadata> parseIt(FetchEmitTuple t2, Fetcher fetcher) {
        FetchKey fetchKey = t2.getFetchKey();
        if (fetchKey.hasRange()) {
            List<Metadata> list;
            block21: {
                if (!(fetcher instanceof RangeFetcher)) {
                    throw new IllegalArgumentException("fetch key has a range, but the fetcher is not a range fetcher");
                }
                Metadata metadata = new Metadata();
                InputStream stream = ((RangeFetcher)fetcher).fetch(fetchKey.getFetchKey(), fetchKey.getRangeStart(), fetchKey.getRangeEnd(), metadata);
                try {
                    list = this.parse(t2, stream, metadata);
                    if (stream == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SecurityException e) {
                        LOG.error("security exception " + t2.getId(), e);
                        throw e;
                    }
                    catch (IOException | TikaException e) {
                        LOG.warn("fetch exception " + t2.getId(), e);
                        this.write(STATUS.FETCH_EXCEPTION, ExceptionUtils.getStackTrace(e));
                    }
                }
                stream.close();
            }
            return list;
        } else {
            List<Metadata> list;
            block22: {
                Metadata metadata = new Metadata();
                InputStream stream = fetcher.fetch(t2.getFetchKey().getFetchKey(), metadata);
                try {
                    list = this.parse(t2, stream, metadata);
                    if (stream == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (SecurityException e) {
                        LOG.error("security exception " + t2.getId(), e);
                        throw e;
                    }
                    catch (IOException | TikaException e) {
                        LOG.warn("fetch exception " + t2.getId(), e);
                        this.write(STATUS.FETCH_EXCEPTION, ExceptionUtils.getStackTrace(e));
                    }
                }
                stream.close();
            }
            return list;
        }
        return null;
    }

    private String getNoFetcherMsg(String fetcherName) {
        StringBuilder sb = new StringBuilder();
        sb.append("Fetcher '").append(fetcherName).append("'");
        sb.append(" not found.");
        sb.append("\nThe configured FetcherManager supports:");
        int i = 0;
        for (String f : this.fetcherManager.getSupported()) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(f);
        }
        return sb.toString();
    }

    private String getNoEmitterMsg(String emitterName) {
        StringBuilder sb = new StringBuilder();
        sb.append("Emitter '").append(emitterName).append("'");
        sb.append(" not found.");
        sb.append("\nThe configured emitterManager supports:");
        int i = 0;
        for (String e : this.emitterManager.getSupported()) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(e);
        }
        return sb.toString();
    }

    private void handleOOM(String taskId, OutOfMemoryError oom) {
        this.write(STATUS.OOM);
        LOG.error("oom: " + taskId, oom);
        this.exit(1);
    }

    private List<Metadata> parse(FetchEmitTuple fetchEmitTuple, InputStream stream, Metadata metadata) {
        HandlerConfig handlerConfig = fetchEmitTuple.getHandlerConfig();
        if (handlerConfig.getParseMode() == HandlerConfig.PARSE_MODE.RMETA) {
            return this.parseRecursive(fetchEmitTuple, handlerConfig, stream, metadata);
        }
        return this.parseConcatenated(fetchEmitTuple, handlerConfig, stream, metadata);
    }

    /*
     * Exception decompiling
     */
    private List<Metadata> parseConcatenated(FetchEmitTuple fetchEmitTuple, HandlerConfig handlerConfig, InputStream stream, Metadata metadata) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<Metadata> parseRecursive(FetchEmitTuple fetchEmitTuple, HandlerConfig handlerConfig, InputStream stream, Metadata metadata) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void injectUserMetadata(Metadata userMetadata, List<Metadata> metadataList) {
        for (String n : userMetadata.names()) {
            metadataList.get(0).set(n, (String)null);
            for (String val : userMetadata.getValues(n)) {
                metadataList.get(0).add(n, val);
            }
        }
    }

    private void exit(int exitCode) {
        if (exitCode != 0) {
            LOG.error("exiting: {}", exitCode);
        } else {
            LOG.info("exiting: {}", exitCode);
        }
        System.exit(exitCode);
    }

    private FetchEmitTuple readFetchEmitTuple() {
        block8: {
            FetchEmitTuple fetchEmitTuple;
            int length = this.input.readInt();
            byte[] bytes = new byte[length];
            this.input.readFully(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
            try {
                fetchEmitTuple = (FetchEmitTuple)objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        objectInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("problem reading tuple", e);
                    this.exit(1);
                    break block8;
                }
                catch (ClassNotFoundException e) {
                    LOG.error("can't find class?!", e);
                    this.exit(1);
                }
            }
            objectInputStream.close();
            return fetchEmitTuple;
        }
        return null;
    }

    private void initializeParser() throws TikaException, IOException, SAXException {
        this.tikaConfig = new TikaConfig(this.tikaConfigPath);
        this.fetcherManager = FetcherManager.load(this.tikaConfigPath);
        this.emitterManager = EmitterManager.load(this.tikaConfigPath);
        this.autoDetectParser = new AutoDetectParser(this.tikaConfig);
        this.rMetaParser = new RecursiveParserWrapper(this.autoDetectParser);
    }

    private void write(EmitData emitData) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(bos);){
                objectOutputStream.writeObject(emitData);
            }
            this.write(STATUS.PARSE_SUCCESS, bos.toByteArray());
        }
        catch (IOException e) {
            LOG.error("problem writing emit data (forking process shutdown?)", e);
            this.exit(1);
        }
    }

    private void write(STATUS status, String msg) {
        byte[] bytes = msg.getBytes(StandardCharsets.UTF_8);
        this.write(status, bytes);
    }

    private void write(STATUS status, byte[] bytes) {
        try {
            int len = bytes.length;
            this.output.write(status.getByte());
            this.output.writeInt(len);
            this.output.write(bytes);
            this.output.flush();
        }
        catch (IOException e) {
            LOG.error("problem writing data (forking process shutdown?)", e);
            this.exit(1);
        }
    }

    private void write(STATUS status) {
        try {
            this.output.write(status.getByte());
            this.output.flush();
        }
        catch (IOException e) {
            LOG.error("problem writing data (forking process shutdown?)", e);
            this.exit(1);
        }
    }

    public static enum STATUS {
        READY,
        CALL,
        PING,
        FAILED_TO_START,
        FETCHER_NOT_FOUND,
        EMITTER_NOT_FOUND,
        FETCHER_INITIALIZATION_EXCEPTION,
        FETCH_EXCEPTION,
        PARSE_SUCCESS,
        PARSE_EXCEPTION_NO_EMIT,
        EMIT_SUCCESS,
        EMIT_SUCCESS_PARSE_EXCEPTION,
        EMIT_EXCEPTION,
        OOM,
        TIMEOUT,
        EMPTY_OUTPUT;


        byte getByte() {
            return (byte)(this.ordinal() + 1);
        }

        public static STATUS lookup(int val) {
            int i = val - 1;
            if (i < 0) {
                throw new IllegalArgumentException("byte must be > 0");
            }
            STATUS[] statuses = STATUS.values();
            if (i >= statuses.length) {
                throw new IllegalArgumentException("byte with index " + i + " must be < " + statuses.length);
            }
            return statuses[i];
        }
    }
}

