/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.nio.ByteBuffer;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallLocation;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingType;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.RecipientInfo;

@SdkInternalApi
public class RecipientInfoMarshaller {
    private static final MarshallingInfo<String> KEYENCRYPTIONALGORITHM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyEncryptionAlgorithm").build();
    private static final MarshallingInfo<ByteBuffer> ATTESTATIONDOCUMENT_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttestationDocument").build();
    private static final RecipientInfoMarshaller instance = new RecipientInfoMarshaller();

    public static RecipientInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecipientInfo recipientInfo, ProtocolMarshaller protocolMarshaller) {
        if (recipientInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(recipientInfo.getKeyEncryptionAlgorithm(), KEYENCRYPTIONALGORITHM_BINDING);
            protocolMarshaller.marshall(recipientInfo.getAttestationDocument(), ATTESTATIONDOCUMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

