/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.tools.commandline.command.DatabaseConnectionGroupOptions;
import schemacrawler.tools.commandline.command.UserCredentialsOptions;
import schemacrawler.tools.commandline.state.BaseStateHolder;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.utility.SchemaCrawlerOptionsConfig;
import schemacrawler.tools.commandline.utility.SchemaRetrievalOptionsConfig;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import schemacrawler.tools.databaseconnector.DatabaseServerHostConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseUrlConnectionOptions;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.UserCredentials;
import us.fatehi.utility.string.StringFormat;

@CommandLine.Command(name="connect", header={"** Connect to the database"}, description={"", "For database connections, please read", "https://www.schemacrawler.com/database-support.html", "first, before running SchemaCrawler", ""}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"connect"}, optionListHeading="Options:%n", footer={"", "For additional options, specific to individual database server plugins,", "run SchemaCrawler with: `-h servers`", "or from the SchemaCrawler interactive shell: `help servers`"})
public class ConnectCommand
extends BaseStateHolder
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ConnectCommand.class.getName());
    @CommandLine.ArgGroup(exclusive=true)
    private DatabaseConnectionGroupOptions databaseConnectionGroupOptions;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    private UserCredentialsOptions userCredentialsOptions;

    public ConnectCommand(ShellState state) {
        super(state);
    }

    public DatabaseConnectionOptions getDatabaseConnectionOptions() {
        if (this.databaseConnectionGroupOptions == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No database connection options provided");
        }
        DatabaseConnectionOptions databaseConnectionOptions = this.databaseConnectionGroupOptions.getDatabaseConnectionOptions();
        if (databaseConnectionOptions == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No database connection options provided");
        }
        return databaseConnectionOptions;
    }

    @Override
    public void run() {
        try {
            DatabaseConnector databaseConnector;
            DatabaseConnectionOptions connectionOptions = this.getDatabaseConnectionOptions();
            Objects.requireNonNull(connectionOptions, "No database connection options provided");
            DatabaseConnectorRegistry databaseConnectorRegistry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
            if (connectionOptions instanceof DatabaseUrlConnectionOptions) {
                DatabaseUrlConnectionOptions options1 = (DatabaseUrlConnectionOptions)connectionOptions;
                String connectionUrl = options1.getConnectionUrl();
                databaseConnector = databaseConnectorRegistry.findDatabaseConnectorFromUrl(connectionUrl);
            } else if (connectionOptions instanceof DatabaseServerHostConnectionOptions) {
                DatabaseServerHostConnectionOptions options = (DatabaseServerHostConnectionOptions)connectionOptions;
                String databaseSystemIdentifier = options.getDatabaseSystemIdentifier();
                if (!databaseConnectorRegistry.hasDatabaseSystemIdentifier(databaseSystemIdentifier)) {
                    throw new ConfigurationException("Unknown server <%s>".formatted(databaseSystemIdentifier));
                }
                databaseConnector = databaseConnectorRegistry.findDatabaseConnectorFromDatabaseSystemIdentifier(databaseSystemIdentifier);
            } else {
                throw new ConfigurationException("Could not create new database connection source");
            }
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Using database plugin <%s>", new Object[]{databaseConnector.getDatabaseServerType()}));
            this.loadSchemaCrawlerOptionsBuilder(databaseConnector);
            this.createDataSource(databaseConnector, connectionOptions, this.getUserCredentials());
            this.loadSchemaRetrievalOptionsBuilder(databaseConnector);
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Cannot connect to database", e);
        }
    }

    private void createDataSource(DatabaseConnector databaseConnector, DatabaseConnectionOptions connectionOptions, UserCredentials userCredentials) {
        Objects.requireNonNull(databaseConnector, "No database plugin provided");
        Objects.requireNonNull(connectionOptions, "No database connection options provided");
        Objects.requireNonNull(userCredentials, "No database connection user credentials provided");
        LOGGER.log(Level.FINE, "Creating data-source");
        DatabaseConnectionSource databaseConnectionSource = databaseConnector.newDatabaseConnectionSource(connectionOptions, userCredentials);
        this.state.setDataSource(databaseConnectionSource);
    }

    private UserCredentials getUserCredentials() {
        if (this.userCredentialsOptions == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No database connection credentials provided");
        }
        UserCredentials userCredentials = this.userCredentialsOptions.getUserCredentials();
        return userCredentials;
    }

    private void loadSchemaCrawlerOptionsBuilder(DatabaseConnector databaseConnector) {
        LOGGER.log(Level.FINE, "Creating SchemaCrawler options builder");
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        schemaCrawlerOptions = databaseConnector.setSchemaCrawlerOptionsDefaults(schemaCrawlerOptions);
        Config config = this.state.getConfig();
        schemaCrawlerOptions = SchemaCrawlerOptionsConfig.fromConfig(schemaCrawlerOptions, config);
        this.state.setSchemaCrawlerOptions(schemaCrawlerOptions);
    }

    private void loadSchemaRetrievalOptionsBuilder(DatabaseConnector databaseConnector) throws SQLException {
        Objects.requireNonNull(databaseConnector, "No database connection options provided");
        LOGGER.log(Level.FINE, "Creating SchemaCrawler retrieval options builder");
        Config config = this.state.getConfig();
        try (Connection connection = (Connection)this.state.getDataSource().get();){
            SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = databaseConnector.getSchemaRetrievalOptionsBuilder(connection);
            this.state.setSchemaRetrievalOptions(SchemaRetrievalOptionsConfig.fromConfig(schemaRetrievalOptionsBuilder, config).toOptions());
        }
    }
}

