/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyUnicodeAsEncodedString;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PyUnicodeAsEncodedString.class})
@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyUnicodeDecode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4, Object var5);

    @Specialization(guards={"frame != null"}, excludeForUncached=true)
    static Object doFast(VirtualFrame frame, Node inliningTarget, Object object, Object encoding, Object errors, @Cached(inline=false) CodecsModuleBuiltins.DecodeNode decodeNode, @Cached PRaiseNode raiseNode) {
        Object unicode = decodeNode.execute(frame, object, encoding, errors);
        if (!PGuards.isString(unicode)) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DECODER_S_RETURNED_P_INSTEAD_OF_STR, encoding, unicode);
        }
        return unicode;
    }

    @Specialization(replaces={"doFast"})
    static Object doWithCall(Node inliningTarget, Object object, Object encoding, Object errors, @Cached PyObjectCallMethodObjArgs callNode) {
        return callNode.execute(null, inliningTarget, PythonContext.get(inliningTarget).getCore().lookupBuiltinModule(BuiltinNames.T__CODECS), BuiltinNames.T_DECODE, object, encoding, errors);
    }
}

