/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.List;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.ExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

class FilteredExemplarReservoir<T extends ExemplarData>
implements ExemplarReservoir<T> {
    private final ExemplarFilter filter;
    private final ExemplarReservoir<T> reservoir;

    FilteredExemplarReservoir(ExemplarFilter filter, ExemplarReservoir<T> reservoir) {
        this.filter = filter;
        this.reservoir = reservoir;
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerDoubleMeasurement(value, attributes, context);
        }
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerLongMeasurement(value, attributes, context);
        }
    }

    @Override
    public List<T> collectAndReset(Attributes pointAttributes) {
        return this.reservoir.collectAndReset(pointAttributes);
    }
}

