/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics;

import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.metrics.ExtendedDoubleHistogram;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.DoubleHistogramBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.LongHistogramBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ThrottlingLogger;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.AbstractInstrument;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentValueType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.SdkLongHistogram;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkDoubleHistogram
extends AbstractInstrument
implements ExtendedDoubleHistogram {
    private static final Logger logger = Logger.getLogger(SdkDoubleHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final MeterSharedState meterSharedState;
    private final WriteableMetricStorage storage;

    private SdkDoubleHistogram(InstrumentDescriptor descriptor, MeterSharedState meterSharedState, WriteableMetricStorage storage) {
        super(descriptor);
        this.meterSharedState = meterSharedState;
        this.storage = storage;
    }

    @Override
    public void record(double value, Attributes attributes, Context context) {
        if (value < 0.0) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(value, attributes, context);
    }

    @Override
    public void record(double value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    @Override
    public void record(double value) {
        this.record(value, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.meterSharedState.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkDoubleHistogramBuilder
    implements ExtendedDoubleHistogramBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleHistogramBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.HISTOGRAM, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState);
        }

        @Override
        public DoubleHistogramBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleHistogramBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkDoubleHistogram build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkDoubleHistogram(x$0, x$1, x$2));
        }

        @Override
        public LongHistogramBuilder ofLongs() {
            return this.builder.swapBuilder(SdkLongHistogram.SdkLongHistogramBuilder::new);
        }

        @Override
        public ExtendedDoubleHistogramBuilder setExplicitBucketBoundariesAdvice(List<Double> bucketBoundaries) {
            try {
                Objects.requireNonNull(bucketBoundaries, "bucketBoundaries must not be null");
                ExplicitBucketHistogramUtils.validateBucketBoundaries(bucketBoundaries);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                logger.warning("Error setting explicit bucket boundaries advice: " + e.getMessage());
                return this;
            }
            this.builder.setExplicitBucketBoundaries(bucketBoundaries);
            return this;
        }

        @Override
        public ExtendedDoubleHistogramBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

