/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression;

import com.github.luben.zstd.BaseZstdBufferDecompressingStreamNoFinalizer;
import com.github.luben.zstd.ZstdBufferDecompressingStreamNoFinalizer;
import com.github.luben.zstd.ZstdDirectBufferDecompressingStreamNoFinalizer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.CompressionUtil;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.compression.Zstd;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.util.ReferenceCounted;

public final class ZstdDecoder
extends ByteToMessageDecoder {
    private final int outCapacity;
    private State currentState;
    private ZstdStream stream;

    public ZstdDecoder() {
        try {
            Zstd.ensureAvailability();
            this.outCapacity = ZstdBufferDecompressingStreamNoFinalizer.recommendedTargetBufferSize();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
        this.currentState = State.DECOMPRESS_DATA;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            if (this.currentState == State.CORRUPTED) {
                in.skipBytes(in.readableBytes());
                return;
            }
            int compressedLength = in.readableBytes();
            if (compressedLength == 0) {
                return;
            }
            if (this.stream == null) {
                this.stream = new ZstdStream(in.isDirect(), this.outCapacity);
            }
            do {
                ByteBuf decompressed;
                if ((decompressed = this.stream.decompress(ctx.alloc(), in)) == null) {
                    return;
                }
                out.add(decompressed);
            } while (in.isReadable());
        }
        catch (DecompressionException e) {
            this.currentState = State.CORRUPTED;
            throw e;
        }
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        try {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
        finally {
            super.handlerRemoved0(ctx);
        }
    }

    private static final class ZstdStream {
        private static final ByteBuffer EMPTY_HEAP_BUFFER = ByteBuffer.allocate(0);
        private static final ByteBuffer EMPTY_DIRECT_BUFFER = ByteBuffer.allocateDirect(0);
        private final boolean direct;
        private final int outCapacity;
        private final BaseZstdBufferDecompressingStreamNoFinalizer decompressingStream;
        private ByteBuffer current;

        ZstdStream(boolean direct, int outCapacity) {
            this.direct = direct;
            this.outCapacity = outCapacity;
            this.decompressingStream = direct ? new ZstdDirectBufferDecompressingStreamNoFinalizer(EMPTY_DIRECT_BUFFER){

                @Override
                protected ByteBuffer refill(ByteBuffer toRefill) {
                    return ZstdStream.this.refill(toRefill);
                }
            } : new ZstdBufferDecompressingStreamNoFinalizer(EMPTY_HEAP_BUFFER){

                @Override
                protected ByteBuffer refill(ByteBuffer toRefill) {
                    return ZstdStream.this.refill(toRefill);
                }
            };
        }

        ByteBuf decompress(ByteBufAllocator alloc, ByteBuf in) throws DecompressionException {
            ByteBuf source;
            if (this.direct && !in.isDirect()) {
                source = alloc.directBuffer(in.readableBytes());
                source.writeBytes(in, in.readerIndex(), in.readableBytes());
            } else if (!this.direct && !in.hasArray()) {
                source = alloc.heapBuffer(in.readableBytes());
                source.writeBytes(in, in.readerIndex(), in.readableBytes());
            } else {
                source = in;
            }
            int inPosition = -1;
            ReferenceCounted outBuffer = null;
            try {
                ByteBuffer inNioBuffer = CompressionUtil.safeNioBuffer(source, source.readerIndex(), source.readableBytes());
                inPosition = inNioBuffer.position();
                assert (inNioBuffer.hasRemaining());
                this.current = inNioBuffer;
                outBuffer = this.direct ? alloc.directBuffer(this.outCapacity) : alloc.heapBuffer(this.outCapacity);
                ByteBuffer target = ((ByteBuf)outBuffer).internalNioBuffer(((ByteBuf)outBuffer).writerIndex(), ((ByteBuf)outBuffer).writableBytes());
                int position = target.position();
                while (true) {
                    if (this.decompressingStream.read(target) != 0 && this.decompressingStream.hasRemaining() && target.hasRemaining() && this.current.hasRemaining()) {
                        continue;
                    }
                    int written = target.position() - position;
                    if (written > 0) {
                        ((ByteBuf)outBuffer).writerIndex(((ByteBuf)outBuffer).writerIndex() + written);
                        ReferenceCounted out = outBuffer;
                        outBuffer = null;
                        ReferenceCounted referenceCounted = out;
                        return referenceCounted;
                    }
                    if (!this.decompressingStream.hasRemaining() || !this.current.hasRemaining()) break;
                }
            }
            catch (IOException e) {
                throw new DecompressionException(e);
            }
            finally {
                int read;
                if (outBuffer != null) {
                    outBuffer.release();
                }
                if (source != in) {
                    source.release();
                }
                ByteBuffer buffer = this.current;
                this.current = null;
                if (inPosition != -1 && (read = buffer.position() - inPosition) > 0) {
                    in.skipBytes(read);
                }
            }
            return null;
        }

        private ByteBuffer refill(ByteBuffer toRefill) {
            return this.current;
        }

        void close() {
            this.decompressingStream.close();
        }
    }

    private static enum State {
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

