/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import java.util.concurrent.Callable;
import net.snowflake.client.jdbc.internal.google.api.client.http.EmptyContent;
import net.snowflake.client.jdbc.internal.google.api.client.http.GenericUrl;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpRequest;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpResponse;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpResponseException;
import net.snowflake.client.jdbc.internal.google.api.services.storage.model.StorageObject;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ByteRangeSpec;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpClientContext;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpContentRange;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableOperationResult;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableSessionFailureScenario;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.Nullable;

final class JsonResumableSessionQueryTask
implements Callable<ResumableOperationResult<StorageObject>> {
    private final HttpClientContext context;
    private final String uploadId;

    JsonResumableSessionQueryTask(HttpClientContext context, String uploadId) {
        this.context = context;
        this.uploadId = uploadId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResumableOperationResult<@Nullable StorageObject> call() {
        HttpResponse response = null;
        try {
            HttpRequest req = this.context.getRequestFactory().buildPutRequest(new GenericUrl(this.uploadId), new EmptyContent()).setParser(this.context.getObjectParser());
            req.setThrowExceptionOnExecuteError(false);
            req.getHeaders().setContentRange(HttpContentRange.query().getHeaderValue());
            response = req.execute();
            int code = response.getStatusCode();
            if (ResumableSessionFailureScenario.isOk(code)) {
                BigInteger actualSize;
                StorageObject storageObject;
                boolean isJson;
                Long contentLength = response.getHeaders().getContentLength();
                String contentType = response.getHeaders().getContentType();
                String storedContentLength = HttpClientContext.firstHeaderValue(response.getHeaders(), "x-goog-stored-content-length");
                boolean bl = isJson = contentType != null && contentType.startsWith("application/json");
                if (isJson) {
                    storageObject = response.parseAs(StorageObject.class);
                    actualSize = storageObject != null ? storageObject.getSize() : null;
                } else if ((contentLength == null || contentLength == 0L) && storedContentLength != null) {
                    response.ignore();
                    actualSize = new BigInteger(storedContentLength, 10);
                    storageObject = null;
                } else {
                    response.ignore();
                    throw ResumableSessionFailureScenario.SCENARIO_0_1.toStorageException(this.uploadId, response, null, () -> null);
                }
                if (actualSize == null) throw ResumableSessionFailureScenario.SCENARIO_0.toStorageException(this.uploadId, response, null, () -> storageObject != null ? storageObject.toString() : null);
                if (storageObject != null) {
                    ResumableOperationResult<StorageObject> resumableOperationResult = ResumableOperationResult.complete(storageObject, actualSize.longValue());
                    return resumableOperationResult;
                }
                ResumableOperationResult<StorageObject> resumableOperationResult = ResumableOperationResult.incremental(actualSize.longValue());
                return resumableOperationResult;
            }
            if (ResumableSessionFailureScenario.isContinue(code)) {
                String range1 = response.getHeaders().getRange();
                if (range1 != null) {
                    ByteRangeSpec range = ByteRangeSpec.parse(range1);
                    long endOffset = range.endOffset();
                    ResumableOperationResult<StorageObject> resumableOperationResult = ResumableOperationResult.incremental(endOffset);
                    return resumableOperationResult;
                }
                ResumableOperationResult<StorageObject> range = ResumableOperationResult.incremental(0L);
                return range;
            }
            HttpResponseException cause = new HttpResponseException(response);
            String contentType = response.getHeaders().getContentType();
            if (ResumableSessionFailureScenario.isOk(code)) throw ResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            if (ResumableSessionFailureScenario.isContinue(code)) throw ResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            if (contentType == null) throw ResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            if (!contentType.startsWith("text/plain")) throw ResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            String errorMessage = cause.getContent().toLowerCase(Locale.US);
            if (!errorMessage.contains("content-range")) throw ResumableSessionFailureScenario.toStorageException(response, cause, this.uploadId);
            throw ResumableSessionFailureScenario.SCENARIO_5.toStorageException(this.uploadId, response, cause, cause::getContent);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (Exception e) {
            throw ResumableSessionFailureScenario.SCENARIO_0.toStorageException(this.uploadId, response, e);
        }
        finally {
            if (response != null) {
                try {
                    response.ignore();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

