/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.tracing;

import java.util.Map;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracer;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracerFactory;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.MethodName;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.MetricsRecorder;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.MetricsTracer;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.SpanName;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;

@BetaApi
@InternalApi
public class MetricsTracerFactory
implements ApiTracerFactory {
    protected MetricsRecorder metricsRecorder;
    private final Map<String, String> attributes;

    public MetricsTracerFactory(MetricsRecorder metricsRecorder) {
        this(metricsRecorder, ImmutableMap.of());
    }

    public MetricsTracerFactory(MetricsRecorder metricsRecorder, Map<String, String> attributes) {
        this.metricsRecorder = metricsRecorder;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    @Override
    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        MetricsTracer metricsTracer = new MetricsTracer(MethodName.of(spanName.getClientName(), spanName.getMethodName()), this.metricsRecorder);
        this.attributes.forEach(metricsTracer::addAttributes);
        return metricsTracer;
    }
}

