/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.api;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.SecurityContext;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.proc.BadJWTException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.util.DateUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public class ResolveClaimsVerifier
extends DefaultJWTClaimsVerifier {
    public ResolveClaimsVerifier() {
        super(null, new HashSet<String>(Arrays.asList("iss", "sub", "iat", "exp", "metadata")));
    }

    @Override
    public void verify(JWTClaimsSet claimsSet, SecurityContext context) throws BadJWTException {
        super.verify(claimsSet, context);
        Date now = new Date();
        if (!DateUtils.isBefore(claimsSet.getIssueTime(), now, this.getMaxClockSkew())) {
            throw new BadJWTException("JWT issue time after current time");
        }
    }
}

