/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.http.impl.auth;

import net.snowflake.client.jdbc.internal.apache.http.annotation.Contract;
import net.snowflake.client.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import net.snowflake.client.jdbc.internal.apache.http.auth.AuthScheme;
import net.snowflake.client.jdbc.internal.apache.http.auth.AuthSchemeFactory;
import net.snowflake.client.jdbc.internal.apache.http.auth.AuthSchemeProvider;
import net.snowflake.client.jdbc.internal.apache.http.impl.auth.SPNegoScheme;
import net.snowflake.client.jdbc.internal.apache.http.params.HttpParams;
import net.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class SPNegoSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public SPNegoSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public SPNegoSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public SPNegoSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }
}

