/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import net.snowflake.client.core.QueryStatus;

public final class QueryStatusV2 {
    private final long endTime;
    private final int errorCode;
    private final String errorMessage;
    private final String id;
    private final String name;
    private final long sessionId;
    private final String sqlText;
    private final long startTime;
    private final String state;
    private final QueryStatus status;
    private final int totalDuration;
    private final String warehouseExternalSize;
    private final int warehouseId;
    private final String warehouseName;
    private final String warehouseServerType;

    public QueryStatusV2(long endTime, int errorCode, String errorMessage, String id, String name, long sessionId, String sqlText, long startTime, String state, int totalDuration, String warehouseExternalSize, int warehouseId, String warehouseName, String warehouseServerType) {
        this.endTime = endTime;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.id = id;
        this.name = name;
        this.sessionId = sessionId;
        this.sqlText = sqlText;
        this.startTime = startTime;
        this.state = state;
        this.status = QueryStatus.getStatusFromString(name);
        this.totalDuration = totalDuration;
        this.warehouseExternalSize = warehouseExternalSize;
        this.warehouseId = warehouseId;
        this.warehouseName = warehouseName;
        this.warehouseServerType = warehouseServerType;
    }

    public static QueryStatusV2 empty() {
        return new QueryStatusV2(0L, 0, "", "", "", 0L, "", 0L, "", 0, "", 0, "", "");
    }

    public boolean isEmpty() {
        return this.name.isEmpty();
    }

    public boolean isStillRunning() {
        return QueryStatus.isStillRunning(this.status);
    }

    public boolean isSuccess() {
        return this.status == QueryStatus.SUCCESS;
    }

    public boolean isAnError() {
        return QueryStatus.isAnError(this.status);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getState() {
        return this.state;
    }

    public int getTotalDuration() {
        return this.totalDuration;
    }

    public String getWarehouseExternalSize() {
        return this.warehouseExternalSize;
    }

    public int getWarehouseId() {
        return this.warehouseId;
    }

    public String getWarehouseName() {
        return this.warehouseName;
    }

    public String getWarehouseServerType() {
        return this.warehouseServerType;
    }

    public String getDescription() {
        return this.name;
    }

    public QueryStatus getStatus() {
        return this.status;
    }
}

