/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import net.snowflake.client.config.SFClientConfig;
import net.snowflake.client.config.SFClientConfigParser;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.HttpHeadersCustomizer;
import net.snowflake.client.jdbc.SFAsyncResultSet;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SFConnectionHandler;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFLogLevel;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.log.SFToJavaLogMapper;

public class DefaultSFConnectionHandler
implements SFConnectionHandler {
    private static final SFLogger logger = SFLoggerFactory.getLogger(DefaultSFConnectionHandler.class);
    private final SFSession sfSession = new SFSession(this);
    private final SnowflakeConnectString conStr;
    private final boolean skipOpen;

    public DefaultSFConnectionHandler(SnowflakeConnectString conStr) {
        this(conStr, false);
    }

    public DefaultSFConnectionHandler(SnowflakeConnectString conStr, boolean skipOpen) {
        this.conStr = conStr;
        this.skipOpen = skipOpen;
        this.sfSession.setSnowflakeConnectionString(conStr);
    }

    public static Map<String, Object> mergeProperties(SnowflakeConnectString conStr) {
        conStr.getParameters().remove("SSL");
        conStr.getParameters().put("SERVERURL", conStr.getScheme() + "://" + conStr.getHost() + ":" + conStr.getPort() + "/");
        return conStr.getParameters();
    }

    @Override
    public boolean supportsAsyncQuery() {
        return true;
    }

    @Override
    public void initializeConnection(String url, Properties info) throws SQLException {
        this.initialize(this.conStr, "JDBC", SnowflakeDriver.implementVersion, info);
    }

    @Override
    public SFBaseSession getSFSession() {
        return this.sfSession;
    }

    @Override
    public SFBaseStatement getSFStatement() {
        return new SFStatement(this.sfSession);
    }

    protected void initialize(SnowflakeConnectString conStr, String appID, String appVersion) throws SQLException {
        this.initialize(conStr, appID, appVersion, null);
    }

    protected void initialize(SnowflakeConnectString conStr, String appID, String appVersion, Properties properties) throws SQLException {
        TelemetryService.getInstance().updateContext(conStr);
        try {
            this.initSessionProperties(conStr, appID, appVersion);
            this.setClientConfig();
            this.initLogger();
            this.initHttpHeaderCustomizers(properties);
            logger.debug("Trying to establish session, JDBC driver: {}", SnowflakeDriver.getJdbcJarname());
            if (!this.skipOpen) {
                this.sfSession.open();
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ex.getSqlState(), ex.getVendorCode(), ex.getCause(), ex.getParams());
        }
    }

    private void setClientConfig() throws SnowflakeSQLLoggedException {
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.sfSession.getConnectionPropertiesMap();
        String clientConfigFilePath = connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.CLIENT_CONFIG_FILE, null);
        SFClientConfig sfClientConfig = this.sfSession.getSfClientConfig();
        if (sfClientConfig == null) {
            try {
                sfClientConfig = SFClientConfigParser.loadSFClientConfig(clientConfigFilePath);
            }
            catch (IOException e) {
                throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ErrorCode.INTERNAL_ERROR, e.getMessage(), e.getCause());
            }
            this.sfSession.setSfClientConfig(sfClientConfig);
        }
    }

    private void initLogger() throws SnowflakeSQLLoggedException {
        if (logger instanceof JDK14Logger && SnowflakeUtil.systemGetProperty("java.util.logging.config.file") == null) {
            Map<SFSessionProperty, Object> connectionPropertiesMap = this.sfSession.getConnectionPropertiesMap();
            String tracingLevelFromConnectionProp = connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.TRACING, null);
            Level logLevel = null;
            String logPattern = "%h/snowflake_jdbc%u.log";
            SFClientConfig sfClientConfig = this.sfSession.getSfClientConfig();
            Path logPath = null;
            if (sfClientConfig != null) {
                String logPathFromConfig = sfClientConfig.getCommonProps().getLogPath();
                logPath = this.getLogPath(logPathFromConfig);
                logPattern = this.constructLogPattern(logPath, logPathFromConfig);
                String levelStr = sfClientConfig.getCommonProps().getLogLevel();
                SFLogLevel sfLogLevel = SFLogLevel.getLogLevel(levelStr);
                logLevel = SFToJavaLogMapper.toJavaUtilLoggingLevel(sfLogLevel);
            }
            if (tracingLevelFromConnectionProp != null) {
                logLevel = Level.parse(tracingLevelFromConnectionProp.toUpperCase());
            }
            if (logLevel != null && logPattern != null) {
                try {
                    logger.debug("Setting logger with log level {} and log pattern {}", logLevel, logPattern);
                    JDK14Logger.instantiateLogger(logLevel, logPattern);
                    if (sfClientConfig != null) {
                        logger.debug("SF Client config found at location: {}.", sfClientConfig.getConfigFilePath());
                        SFClientConfigParser.checkConfigFilePermissions(sfClientConfig.getConfigFilePath());
                    }
                    if (logPath != null) {
                        this.checkLogFolderPermissions(logPath);
                    }
                }
                catch (IOException ex) {
                    throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ErrorCode.INTERNAL_ERROR, ex.getMessage());
                }
                logger.debug("Instantiating JDK14Logger with level: {}, output path: {}", logLevel, logPattern);
            }
        }
    }

    private Path getLogPath(String logPathFromConfig) throws SnowflakeSQLLoggedException {
        Path logPath;
        if (JDK14Logger.STDOUT.equalsIgnoreCase(logPathFromConfig)) {
            return null;
        }
        if (logPathFromConfig != null && !logPathFromConfig.isEmpty()) {
            logPath = Paths.get(logPathFromConfig, new String[0]);
            if (!Files.exists(logPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(logPath, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ErrorCode.INTERNAL_ERROR, String.format("Unable to create log path mentioned in configfile %s ,%s", logPathFromConfig, ex.getMessage()));
                }
            }
        } else {
            String homePath = SnowflakeUtil.systemGetProperty("user.home");
            if (homePath == null || homePath.isEmpty()) {
                throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ErrorCode.INTERNAL_ERROR, String.format("Log path not set in configfile %s and home directory not set.", logPathFromConfig));
            }
            logPath = Paths.get(homePath, new String[0]);
        }
        return this.createLogPathSubDirectory(logPath);
    }

    private String constructLogPattern(Path logPath, String logPathFromConfig) {
        if (JDK14Logger.STDOUT.equalsIgnoreCase(logPathFromConfig)) {
            return JDK14Logger.STDOUT;
        }
        String logPattern = "%t/snowflake_jdbc%u.log";
        logPattern = Paths.get(logPath.toString(), "snowflake_jdbc%u.log").toString();
        return logPattern;
    }

    private Path createLogPathSubDirectory(Path logPath) throws SnowflakeSQLLoggedException {
        Path path = Paths.get(logPath.toString(), "jdbc");
        if (!Files.exists(path, new LinkOption[0])) {
            this.createLogFolder(path);
        }
        return path;
    }

    private void createLogFolder(Path path) throws SnowflakeSQLLoggedException {
        try {
            if (Constants.getOS() == Constants.OS.WINDOWS) {
                Files.createDirectories(path, new FileAttribute[0]);
            } else {
                Files.createDirectories(path, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------")));
            }
        }
        catch (IOException ex) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ErrorCode.INTERNAL_ERROR, String.format("Unable to create jdbc subfolder in configfile %s ,%s", path.toString(), ex.getMessage(), ex.getCause()));
        }
    }

    private void checkLogFolderPermissions(Path path) throws SnowflakeSQLLoggedException {
        if (!SnowflakeUtil.isWindows()) {
            try {
                Set<PosixFilePermission> folderPermissions = Files.getPosixFilePermissions(path, new LinkOption[0]);
                if (folderPermissions.contains((Object)PosixFilePermission.GROUP_WRITE) || folderPermissions.contains((Object)PosixFilePermission.GROUP_READ) || folderPermissions.contains((Object)PosixFilePermission.GROUP_EXECUTE) || folderPermissions.contains((Object)PosixFilePermission.OTHERS_WRITE) || folderPermissions.contains((Object)PosixFilePermission.OTHERS_READ) || folderPermissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
                    logger.warn("Access permission for the logs directory {} is currently {} and is potentially accessible to users other than the owner of the logs directory.", path.toString(), folderPermissions.toString());
                }
            }
            catch (IOException ex) {
                throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ErrorCode.INTERNAL_ERROR, String.format("Unable to get permissions of log directory %s ,%s", path.toString(), ex.getMessage(), ex.getCause()));
            }
        }
    }

    private void initSessionProperties(SnowflakeConnectString conStr, String appID, String appVersion) throws SFException {
        Map<String, Object> properties = DefaultSFConnectionHandler.mergeProperties(conStr);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            block8: {
                Object v0;
                if ("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY".equals(entry.getKey())) {
                    try {
                        v0 = entry.getValue();
                        int intV = v0 instanceof Integer ? (Integer)v0 : Integer.parseInt((String)v0);
                        if (intV > 3600) {
                            properties.replace(entry.getKey(), "3600");
                        }
                        if (intV < 900) {
                            properties.replace(entry.getKey(), "900");
                        }
                        break block8;
                    }
                    catch (NumberFormatException ex) {
                        logger.warn("Invalid data type for CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY: {}", entry.getValue());
                        continue;
                    }
                }
                if ("CLIENT_SFSQL".equals(entry.getKey())) {
                    v0 = entry.getValue();
                    boolean booleanV = v0 instanceof Boolean ? (Boolean)v0 : Boolean.parseBoolean((String)v0);
                    this.sfSession.setSfSQLMode(booleanV);
                }
            }
            this.sfSession.addSFSessionProperty(entry.getKey(), entry.getValue());
        }
        this.sfSession.overrideConsoleHandlerWhenNecessary();
        this.sfSession.addProperty(SFSessionProperty.APP_ID, (Object)appID);
        this.sfSession.addProperty(SFSessionProperty.APP_VERSION, (Object)appVersion);
        for (Map.Entry<String, Object> entry : SessionUtil.JVM_PARAMS_TO_PARAMS.entrySet()) {
            String value = SnowflakeUtil.systemGetProperty(entry.getKey());
            if (value == null || this.sfSession.containProperty((String)entry.getValue())) continue;
            this.sfSession.addSFSessionProperty((String)entry.getValue(), value);
        }
    }

    @Override
    public ResultSet createResultSet(String queryID, Statement statement) throws SQLException {
        SFAsyncResultSet rs = new SFAsyncResultSet(queryID, statement);
        rs.setSession(this.sfSession);
        rs.setStatement(statement);
        return rs;
    }

    @Override
    public SnowflakeBaseResultSet createResultSet(SFBaseResultSet resultSet, Statement statement) throws SQLException {
        return new SnowflakeResultSetV1(resultSet, statement);
    }

    @Override
    public SnowflakeBaseResultSet createAsyncResultSet(SFBaseResultSet resultSet, Statement statement) throws SQLException {
        return new SFAsyncResultSet(resultSet, statement);
    }

    @Override
    public SFBaseFileTransferAgent getFileTransferAgent(String command, SFBaseStatement statement) throws SQLNonTransientConnectionException, SnowflakeSQLException {
        if (!(statement instanceof SFStatement)) {
            throw new SnowflakeSQLException("getFileTransferAgent() called with an incompatible SFBaseStatement type. Requires an SFStatement.");
        }
        return new SnowflakeFileTransferAgent(command, this.sfSession, (SFStatement)statement);
    }

    private void initHttpHeaderCustomizers(Properties properties) {
        if (properties == null) {
            return;
        }
        Object httpHeadersCustomizers = properties.get("net.snowflake.client.jdbc.HttpHeadersCustomizer");
        if (httpHeadersCustomizers instanceof List) {
            ArrayList<HttpHeadersCustomizer> typedCustomizers = new ArrayList<HttpHeadersCustomizer>();
            for (Object customizer : (List)httpHeadersCustomizers) {
                if (customizer instanceof HttpHeadersCustomizer) {
                    typedCustomizers.add((HttpHeadersCustomizer)customizer);
                    continue;
                }
                if (customizer == null) continue;
                logger.warn("Invalid object type found in HttpHeadersCustomizer list: {}", customizer.getClass().getName());
            }
            logger.debug("Registering {} HttpHeadersCustomizer", typedCustomizers.size());
            this.sfSession.setHttpHeadersCustomizers(typedCustomizers);
        }
    }
}

