/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.BaseSqlInput;
import net.snowflake.client.core.ColumnTypeHelper;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SfTimestampUtil;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.core.structs.SQLDataCreationHelper;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.type.TypeReference;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.ThrowingBiFunction;

@SnowflakeJdbcInternalApi
public class JsonSqlInput
extends BaseSqlInput {
    private static final SFLogger logger = SFLoggerFactory.getLogger(JsonSqlInput.class);
    private final String text;
    private final JsonNode input;
    private final Iterator<JsonNode> elements;
    private final TimeZone sessionTimeZone;
    private int currentIndex = 0;
    private boolean wasNull = false;

    public JsonSqlInput(String text, JsonNode input, SFBaseSession session, Converters converters, List<FieldMetadata> fields, TimeZone sessionTimeZone) {
        super(session, converters, fields);
        this.text = text;
        this.input = input;
        this.elements = input.elements();
        this.sessionTimeZone = sessionTimeZone;
    }

    public JsonNode getInput() {
        return this.input;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String readString() throws SQLException {
        return this.withNextValue(this::convertString);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        return this.withNextValue(this::convertBoolean);
    }

    @Override
    public byte readByte() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getByte(value)));
    }

    @Override
    public short readShort() throws SQLException {
        return this.withNextValue(this::convertShort);
    }

    @Override
    public int readInt() throws SQLException {
        return this.withNextValue(this::convertInt);
    }

    @Override
    public long readLong() throws SQLException {
        return this.withNextValue(this::convertLong);
    }

    @Override
    public float readFloat() throws SQLException {
        return this.withNextValue(this::convertFloat).floatValue();
    }

    @Override
    public double readDouble() throws SQLException {
        return this.withNextValue(this::convertDouble);
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return this.withNextValue(this::convertBigDecimal);
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return this.withNextValue(this::convertBytes);
    }

    @Override
    public Date readDate() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.convertDate((String)value);
        });
    }

    private Date convertDate(String value) {
        SnowflakeDateTimeFormat formatter = JsonSqlInput.getFormat(this.session, "DATE_OUTPUT_FORMAT");
        SFTimestamp timestamp = formatter.parse(value);
        return Date.valueOf(Instant.ofEpochMilli(timestamp.getTime()).atZone(ZoneOffset.UTC).toLocalDate());
    }

    @Override
    public Time readTime() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.convertTime((String)value);
        });
    }

    private Time convertTime(String value) {
        SnowflakeDateTimeFormat formatter = JsonSqlInput.getFormat(this.session, "TIME_OUTPUT_FORMAT");
        SFTimestamp timestamp = formatter.parse(value);
        return Time.valueOf(Instant.ofEpochMilli(timestamp.getTime()).atZone(ZoneOffset.UTC).toLocalTime());
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return this.readTimestamp(null);
    }

    @Override
    public Timestamp readTimestamp(TimeZone tz) throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.convertTimestamp(tz, value, (FieldMetadata)fieldMetadata);
        });
    }

    @Override
    public <T> T readObject(Class<T> type, TimeZone tz) throws SQLException {
        return (T)this.withNextValue((value, fieldMetadata) -> this.convertObject(type, tz, value, (FieldMetadata)fieldMetadata));
    }

    private <T> T convertObject(Class<T> type, TimeZone tz, Object value, FieldMetadata fieldMetadata) throws SQLException {
        if (value == null) {
            return null;
        }
        if (SQLData.class.isAssignableFrom(type)) {
            if (!JsonNode.class.isAssignableFrom(value.getClass())) {
                logger.error("Object of class JsonNode is expected to convert to SqlData", new Object[0]);
                return null;
            }
            JsonNode jsonNode = (JsonNode)value;
            JsonSqlInput sqlInput = new JsonSqlInput(null, jsonNode, this.session, this.converters, fieldMetadata.getFields(), this.sessionTimeZone);
            SQLData instance = (SQLData)SQLDataCreationHelper.create(type);
            instance.readSQL(sqlInput, null);
            return (T)instance;
        }
        if (Map.class.isAssignableFrom(type)) {
            if (value == null) {
                return null;
            }
            return (T)this.convertSqlInputToMap((SQLInput)value);
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)this.convertString(value, fieldMetadata);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (T)this.convertBoolean(value, fieldMetadata);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (T)this.convertString(value, fieldMetadata);
        }
        if (Short.class.isAssignableFrom(type)) {
            return (T)this.convertShort(value, fieldMetadata);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (T)this.convertInt(value, fieldMetadata);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (T)this.convertLong(value, fieldMetadata);
        }
        if (Float.class.isAssignableFrom(type)) {
            return (T)this.convertFloat(value, fieldMetadata);
        }
        if (Double.class.isAssignableFrom(type)) {
            return (T)this.convertFloat(value, fieldMetadata);
        }
        if (Date.class.isAssignableFrom(type)) {
            return (T)this.convertDate((String)value);
        }
        if (Time.class.isAssignableFrom(type)) {
            return (T)this.convertTime((String)value);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (T)this.convertTimestamp(tz, value, fieldMetadata);
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (T)this.convertBigDecimal(value, fieldMetadata);
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (T)this.convertBytes(value, fieldMetadata);
        }
        logger.debug("Unsupported type passed to readObject(int columnIndex,Class<T> type): " + type.getName(), new Object[0]);
        throw new SQLException("Type passed to 'getObject(int columnIndex,Class<T> type)' is unsupported. Type: " + type.getName());
    }

    @Override
    public <T> List<T> readList(Class<T> type) throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            ArrayList result = new ArrayList();
            if (ArrayNode.class.isAssignableFrom(value.getClass())) {
                for (JsonNode node : (ArrayNode)value) {
                    result.add(this.convertObject(type, TimeZone.getDefault(), this.getValue(node), fieldMetadata.getFields().get(0)));
                }
                return result;
            }
            logger.debug("Given object could not be converted to List of type: " + type.getName(), new Object[0]);
            throw new SQLException("Given object could not be converted to List of type: " + type.getName());
        });
    }

    @Override
    public <T> T[] readArray(Class<T> type) throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            if (ArrayNode.class.isAssignableFrom(value.getClass())) {
                ArrayNode valueNodes = (ArrayNode)value;
                Object[] array = (Object[])Array.newInstance(type, valueNodes.size());
                int counter = 0;
                for (JsonNode node : valueNodes) {
                    array[counter++] = this.convertObject(type, TimeZone.getDefault(), this.getValue(node), fieldMetadata.getFields().get(0));
                }
                return array;
            }
            logger.debug("Given object could not be converted to Array of type: " + type.getName(), new Object[0]);
            throw new SQLException("Given object could not be converted to List of type: " + type.getName());
        });
    }

    @Override
    public <T> Map<String, T> readMap(Class<T> type) throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            if (ObjectNode.class.isAssignableFrom(value.getClass())) {
                HashMap result = new HashMap();
                ObjectNode arrayNode = (ObjectNode)value;
                Iterator<String> it = arrayNode.fieldNames();
                while (it.hasNext()) {
                    String key = it.next();
                    result.put(key, this.convertObject(type, TimeZone.getDefault(), this.getValue(arrayNode.get(key)), (FieldMetadata)fieldMetadata));
                }
                return result;
            }
            logger.debug("Given object could not be converted to Map of String and type: " + type.getName(), new Object[0]);
            throw new SQLException("Given object could not be converted to Map of String and type: " + type.getName());
        });
    }

    private Timestamp convertTimestamp(TimeZone tz, Object value, FieldMetadata fieldMetadata) throws SQLException {
        if (value == null) {
            return null;
        }
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        int columnSubType = fieldMetadata.getType();
        int scale = fieldMetadata.getScale();
        Timestamp result = SfTimestampUtil.getTimestampFromType(columnSubType, (String)value, this.session, this.sessionTimeZone, tz);
        if (result != null) {
            return result;
        }
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getDateTimeConverter().getTimestamp(value, columnType, columnSubType, tz, scale));
    }

    @Override
    public Object readObject() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> value);
    }

    @Override
    public <T> T readObject(Class<T> type) throws SQLException {
        return this.readObject(type, this.sessionTimeZone);
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    Map<String, Object> convertSqlInputToMap(SQLInput sqlInput) {
        return SFBaseResultSet.OBJECT_MAPPER.convertValue((Object)((JsonSqlInput)sqlInput).getInput(), new TypeReference<Map<String, Object>>(){});
    }

    private <T> T withNextValue(ThrowingBiFunction<Object, FieldMetadata, T, SQLException> action) throws SQLException {
        JsonNode jsonNode = this.elements.next();
        Object value = this.getValue(jsonNode);
        this.wasNull = value == null;
        return action.apply(value, (FieldMetadata)this.fields.get(this.currentIndex++));
    }

    private Object getValue(JsonNode jsonNode) {
        if (jsonNode.isTextual()) {
            return jsonNode.textValue();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.booleanValue();
        }
        if (jsonNode.isNumber()) {
            return jsonNode.numberValue();
        }
        if (jsonNode.isObject() || jsonNode.isArray()) {
            return jsonNode;
        }
        return null;
    }

    private static SnowflakeDateTimeFormat getFormat(SFBaseSession session, String format) {
        return SnowflakeDateTimeFormat.fromSqlFormat((String)session.getCommonParameters().get(format));
    }
}

