import { Hook, Interfaces } from '@oclif/core';
export declare function hasNotBeenMsSinceDate(ms: number, now: Date, date: Date): boolean;
export declare function convertToMs(frequency: number, unit: 'days' | 'hours' | 'milliseconds' | 'minutes' | 'seconds'): number;
export declare function getEnvVarNumber(envVar: string, defaultValue?: number): number | undefined;
export declare function getEnvVarEnum<T extends string>(envVar: string, allowed: T[], defaultValue: T): T;
export declare function getEnvVarEnum<T extends string>(envVar: string, allowed: T[], defaultValue?: T): T | undefined;
export declare function semverGreaterThan(a: string, b: string): boolean;
/**
 * Returns the newest version of the CLI from the cache if it is newer than the current version.
 *
 * Returns undefined early if:
 * - `update` command is being run
 * - `<CLI>_SKIP_NEW_VERSION_CHECK` is set to true
 * - the current version is a prerelease
 * - the warning was last shown to the user within the frequency and frequencyUnit
 */
export declare function getNewerVersion({ argv, config, lastWarningFile, versionFile, }: {
    argv: string[];
    config: Interfaces.Config;
    lastWarningFile: string;
    versionFile: string;
}): Promise<string | undefined>;
declare const hook: Hook.Init;
export default hook;
