/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DtFileOperations;
import org.apache.hadoop.tools.CommandShell;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtUtilShell
extends CommandShell {
    private static final Logger LOG = LoggerFactory.getLogger(DtUtilShell.class);
    private static final String FORMAT_SUBSTRING = "[-format (java|protobuf)]";
    public static final String DT_USAGE = "hadoop dtutil [-keytab <keytab_file> -principal <principal_name>] subcommand (help|print|get|edit|append|cancel|remove|renew) [-format (java|protobuf)] [-alias <alias>] filename...";
    private static final String HELP = "help";
    private static final String KEYTAB = "-keytab";
    private static final String PRINCIPAL = "-principal";
    private static final String PRINT = "print";
    private static final String GET = "get";
    private static final String EDIT = "edit";
    private static final String APPEND = "append";
    private static final String CANCEL = "cancel";
    private static final String REMOVE = "remove";
    private static final String RENEW = "renew";
    private static final String IMPORT = "import";
    private static final String RENEWER = "-renewer";
    private static final String SERVICE = "-service";
    private static final String ALIAS = "-alias";
    private static final String FORMAT = "-format";
    private String keytab = null;
    private String principal = null;
    private Text alias = null;
    private Text service = null;
    private String renewer = null;
    private String format = "protobuf";
    private ArrayList<File> tokenFiles = null;
    private File firstFile = null;

    private String[] maybeDoLoginFromKeytabAndPrincipal(String[] args) throws IOException {
        ArrayList<String> savedArgs = new ArrayList<String>(args.length);
        for (int i = 0; i < args.length; ++i) {
            String current = args[i];
            if (current.equals(PRINCIPAL)) {
                this.principal = args[++i];
                continue;
            }
            if (current.equals(KEYTAB)) {
                this.keytab = args[++i];
                continue;
            }
            savedArgs.add(current);
        }
        int newSize = savedArgs.size();
        if (newSize != args.length) {
            if (this.principal != null && this.keytab != null) {
                UserGroupInformation.loginUserFromKeytab(this.principal, this.keytab);
            } else {
                LOG.warn("-principal and -keytab not both specified!  Kerberos login not attempted.");
            }
            return savedArgs.toArray(new String[newSize]);
        }
        return args;
    }

    @Override
    protected int init(String[] args) throws Exception {
        if (0 == args.length) {
            return 1;
        }
        this.tokenFiles = new ArrayList();
        args = this.maybeDoLoginFromKeytabAndPrincipal(args);
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                String command = args[0];
                if (command.equals(HELP)) {
                    return 1;
                }
                if (command.equals(PRINT)) {
                    this.setSubCommand(new Print());
                    continue;
                }
                if (command.equals(GET)) {
                    this.setSubCommand(new Get(args[++i]));
                    continue;
                }
                if (command.equals(EDIT)) {
                    this.setSubCommand(new Edit());
                    continue;
                }
                if (command.equals(APPEND)) {
                    this.setSubCommand(new Append());
                    continue;
                }
                if (command.equals(CANCEL)) {
                    this.setSubCommand(new Remove(true));
                    continue;
                }
                if (command.equals(REMOVE)) {
                    this.setSubCommand(new Remove(false));
                    continue;
                }
                if (command.equals(RENEW)) {
                    this.setSubCommand(new Renew());
                    continue;
                }
                if (!command.equals(IMPORT)) continue;
                this.setSubCommand(new Import(args[++i]));
                continue;
            }
            if (args[i].equals(ALIAS)) {
                this.alias = new Text(args[++i]);
                continue;
            }
            if (args[i].equals(SERVICE)) {
                this.service = new Text(args[++i]);
                continue;
            }
            if (args[i].equals(RENEWER)) {
                this.renewer = args[++i];
                continue;
            }
            if (args[i].equals(FORMAT)) {
                this.format = args[++i];
                if (this.format.equals("java") || this.format.equals("protobuf")) continue;
                LOG.error("-format must be 'java' or 'protobuf' not '" + this.format + "'");
                return 1;
            }
            while (i < args.length) {
                File f = new File(args[i]);
                if (f.exists()) {
                    this.tokenFiles.add(f);
                }
                if (this.firstFile == null) {
                    this.firstFile = f;
                }
                ++i;
            }
            if (this.tokenFiles.size() != 0 || this.firstFile != null) continue;
            LOG.error("Must provide a filename to all commands.");
            return 1;
        }
        return 0;
    }

    @Override
    public String getCommandUsage() {
        return String.format("%n%s%n   %s%n   %s%n   %s%n   %s%n   %s%n   %s%n   %s%n   %s%n%n", DT_USAGE, new Print().getUsage(), new Get().getUsage(), new Edit().getUsage(), new Append().getUsage(), new Remove(true).getUsage(), new Remove(false).getUsage(), new Renew().getUsage(), new Import().getUsage());
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run(new Configuration(), new DtUtilShell(), args));
    }

    private class Import
    extends CommandShell.SubCommand {
        public static final String IMPORT_USAGE = "dtutil import <base64> [-alias <alias>] [-format (java|protobuf)] filename";
        private String base64 = null;

        Import() {
        }

        Import(String arg) {
            this.base64 = arg;
        }

        @Override
        public boolean validate() {
            return true;
        }

        @Override
        public void execute() throws Exception {
            DtFileOperations.importTokenFile(DtUtilShell.this.firstFile, DtUtilShell.this.format, DtUtilShell.this.alias, this.base64, DtUtilShell.this.getConf());
        }

        @Override
        public String getUsage() {
            return IMPORT_USAGE;
        }
    }

    private class Renew
    extends CommandShell.SubCommand {
        public static final String RENEW_USAGE = "dtutil renew -alias <alias> filename...";

        private Renew() {
        }

        @Override
        public boolean validate() {
            if (DtUtilShell.this.alias == null) {
                LOG.error("-alias flag is not optional for renew");
                return false;
            }
            return true;
        }

        @Override
        public void execute() throws Exception {
            for (File tokenFile : DtUtilShell.this.tokenFiles) {
                DtFileOperations.renewTokenFile(tokenFile, DtUtilShell.this.format, DtUtilShell.this.alias, DtUtilShell.this.getConf());
            }
        }

        @Override
        public String getUsage() {
            return RENEW_USAGE;
        }
    }

    private class Remove
    extends CommandShell.SubCommand {
        public static final String REMOVE_USAGE = "dtutil remove -alias <alias> [-format (java|protobuf)] filename...";
        public static final String CANCEL_USAGE = "dtutil cancel -alias <alias> [-format (java|protobuf)] filename...";
        private boolean cancel = false;

        public Remove(boolean arg) {
            this.cancel = arg;
        }

        @Override
        public boolean validate() {
            if (DtUtilShell.this.alias == null) {
                LOG.error("-alias flag is not optional for remove or cancel");
                return false;
            }
            return true;
        }

        @Override
        public void execute() throws Exception {
            for (File tokenFile : DtUtilShell.this.tokenFiles) {
                DtFileOperations.removeTokenFromFile(this.cancel, tokenFile, DtUtilShell.this.format, DtUtilShell.this.alias, DtUtilShell.this.getConf());
            }
        }

        @Override
        public String getUsage() {
            if (this.cancel) {
                return CANCEL_USAGE;
            }
            return REMOVE_USAGE;
        }
    }

    private class Append
    extends CommandShell.SubCommand {
        public static final String APPEND_USAGE = "dtutil append [-format (java|protobuf)]filename...";

        private Append() {
        }

        @Override
        public void execute() throws Exception {
            DtFileOperations.appendTokenFiles(DtUtilShell.this.tokenFiles, DtUtilShell.this.format, DtUtilShell.this.getConf());
        }

        @Override
        public String getUsage() {
            return APPEND_USAGE;
        }
    }

    private class Edit
    extends CommandShell.SubCommand {
        public static final String EDIT_USAGE = "dtutil edit -service <service> -alias <alias> [-format (java|protobuf)]filename...";

        private Edit() {
        }

        @Override
        public boolean validate() {
            if (DtUtilShell.this.service == null) {
                LOG.error("must pass -service field with dtutil edit command");
                return false;
            }
            if (DtUtilShell.this.alias == null) {
                LOG.error("must pass -alias field with dtutil edit command");
                return false;
            }
            return true;
        }

        @Override
        public void execute() throws Exception {
            for (File tokenFile : DtUtilShell.this.tokenFiles) {
                DtFileOperations.aliasTokenFile(tokenFile, DtUtilShell.this.format, DtUtilShell.this.alias, DtUtilShell.this.service, DtUtilShell.this.getConf());
            }
        }

        @Override
        public String getUsage() {
            return EDIT_USAGE;
        }
    }

    private class Get
    extends CommandShell.SubCommand {
        public static final String GET_USAGE = "dtutil get URL [-service <scheme>] [-format (java|protobuf)][-alias <alias>] [-renewer <renewer>] filename";
        private static final String PREFIX_HTTP = "http://";
        private static final String PREFIX_HTTPS = "https://";
        private String url = null;

        public Get() {
        }

        public Get(String arg) {
            this.url = arg;
        }

        public boolean isGenericUrl() {
            return this.url.startsWith(PREFIX_HTTP) || this.url.startsWith(PREFIX_HTTPS);
        }

        @Override
        public boolean validate() {
            if (DtUtilShell.this.service != null && !this.isGenericUrl()) {
                LOG.error("Only provide -service with http/https URL.");
                return false;
            }
            if (DtUtilShell.this.service == null && this.isGenericUrl()) {
                LOG.error("Must provide -service with http/https URL.");
                return false;
            }
            if (this.url.indexOf("://") == -1) {
                LOG.error("URL does not contain a service specification: " + this.url);
                return false;
            }
            return true;
        }

        @Override
        public void execute() throws Exception {
            DtFileOperations.getTokenFile(DtUtilShell.this.firstFile, DtUtilShell.this.format, DtUtilShell.this.alias, DtUtilShell.this.service, this.url, DtUtilShell.this.renewer, DtUtilShell.this.getConf());
        }

        @Override
        public String getUsage() {
            return GET_USAGE;
        }
    }

    private class Print
    extends CommandShell.SubCommand {
        public static final String PRINT_USAGE = "dtutil print [-alias <alias>] filename...";

        private Print() {
        }

        @Override
        public void execute() throws Exception {
            for (File tokenFile : DtUtilShell.this.tokenFiles) {
                DtFileOperations.printTokenFile(tokenFile, DtUtilShell.this.alias, DtUtilShell.this.getConf(), DtUtilShell.this.getOut());
            }
        }

        @Override
        public String getUsage() {
            return PRINT_USAGE;
        }
    }
}

