/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.transform;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.tribuo.FeatureMap;
import org.tribuo.transform.Transformation;

public class TransformationMap
implements Configurable,
Provenancable<ConfiguredObjectProvenance> {
    @Config(mandatory=true, description="Global transformations to apply after the feature specific transforms.")
    private List<Transformation> globalTransformations;
    @Config(description="Feature specific transformations. Accepts regexes for feature names.")
    private Map<String, TransformationList> featureTransformationList = new HashMap<String, TransformationList>();
    private final Map<String, List<Transformation>> featureTransformations = new HashMap<String, List<Transformation>>();
    private ConfiguredObjectProvenanceImpl provenance;

    private TransformationMap() {
    }

    public TransformationMap(List<Transformation> globalTransformations, Map<String, List<Transformation>> featureTransformations) {
        this.globalTransformations = new ArrayList<Transformation>(globalTransformations);
        this.featureTransformations.putAll(featureTransformations);
        for (Map.Entry<String, List<Transformation>> e : featureTransformations.entrySet()) {
            this.featureTransformationList.put(e.getKey(), new TransformationList(e.getValue()));
        }
    }

    public TransformationMap(List<Transformation> globalTransformations) {
        this(globalTransformations, Collections.emptyMap());
    }

    public TransformationMap(Map<String, List<Transformation>> featureTransformations) {
        this(Collections.emptyList(), featureTransformations);
    }

    public void postConfig() {
        if (this.globalTransformations.isEmpty() && this.featureTransformationList.isEmpty()) {
            throw new PropertyException("TransformationMap", "Both global transformations and feature transformations can't be empty!");
        }
        for (Map.Entry<String, TransformationList> e : this.featureTransformationList.entrySet()) {
            this.featureTransformations.put(e.getKey(), e.getValue().list);
        }
    }

    public boolean validateTransformations(FeatureMap featureMap) {
        HashSet<String> featuresWithPatterns = new HashSet<String>();
        ArrayList<String> featureNames = new ArrayList<String>(featureMap.keySet());
        boolean valid = true;
        for (String regex : this.featureTransformations.keySet()) {
            Pattern p = Pattern.compile(regex);
            for (String s : featureNames) {
                if (p.matcher(s).matches() && !(valid = featuresWithPatterns.add(s))) break;
            }
            if (valid) continue;
            break;
        }
        return valid;
    }

    public String toString() {
        return "TransformationMap(featureTransformations=" + this.featureTransformations.toString() + ",globalTransformations=" + this.globalTransformations.toString() + ")";
    }

    public List<Transformation> getGlobalTransformations() {
        return this.globalTransformations;
    }

    public Map<String, List<Transformation>> getFeatureTransformations() {
        return this.featureTransformations;
    }

    public synchronized ConfiguredObjectProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = this.cacheProvenance();
        }
        return this.provenance;
    }

    private ConfiguredObjectProvenanceImpl cacheProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "TransformationMap");
    }

    public static final class TransformationList
    implements Configurable,
    Provenancable<ConfiguredObjectProvenance> {
        @Config(description="A list of transformations to apply.")
        public List<Transformation> list;

        private TransformationList() {
        }

        public TransformationList(List<Transformation> list) {
            this.list = list;
        }

        public ConfiguredObjectProvenance getProvenance() {
            return new ConfiguredObjectProvenanceImpl((Configurable)this, "TransformationList");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransformationList)) {
                return false;
            }
            TransformationList that = (TransformationList)o;
            return this.list.equals(that.list);
        }

        public int hashCode() {
            return Objects.hash(this.list);
        }
    }
}

