/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.CsvHeaderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CsvOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CsvOptions> {
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Delimiter").getter(CsvOptions.getter(CsvOptions::delimiter)).setter(CsvOptions.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()}).build();
    private static final SdkField<List<String>> HEADER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HeaderList").getter(CsvOptions.getter(CsvOptions::headerList)).setter(CsvOptions.setter(Builder::headerList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIMITER_FIELD, HEADER_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CsvOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String delimiter;
    private final List<String> headerList;

    private CsvOptions(BuilderImpl builder) {
        this.delimiter = builder.delimiter;
        this.headerList = builder.headerList;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final boolean hasHeaderList() {
        return this.headerList != null && !(this.headerList instanceof SdkAutoConstructList);
    }

    public final List<String> headerList() {
        return this.headerList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaderList() ? this.headerList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsvOptions)) {
            return false;
        }
        CsvOptions other = (CsvOptions)obj;
        return Objects.equals(this.delimiter(), other.delimiter()) && this.hasHeaderList() == other.hasHeaderList() && Objects.equals(this.headerList(), other.headerList());
    }

    public final String toString() {
        return ToString.builder((String)"CsvOptions").add("Delimiter", (Object)this.delimiter()).add("HeaderList", this.hasHeaderList() ? this.headerList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "HeaderList": {
                return Optional.ofNullable(clazz.cast(this.headerList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Delimiter", DELIMITER_FIELD);
        map.put("HeaderList", HEADER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CsvOptions, T> g) {
        return obj -> g.apply((CsvOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String delimiter;
        private List<String> headerList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CsvOptions model) {
            this.delimiter(model.delimiter);
            this.headerList(model.headerList);
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final Collection<String> getHeaderList() {
            if (this.headerList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.headerList;
        }

        public final void setHeaderList(Collection<String> headerList) {
            this.headerList = CsvHeaderListCopier.copy(headerList);
        }

        @Override
        public final Builder headerList(Collection<String> headerList) {
            this.headerList = CsvHeaderListCopier.copy(headerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerList(String ... headerList) {
            this.headerList(Arrays.asList(headerList));
            return this;
        }

        public CsvOptions build() {
            return new CsvOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CsvOptions> {
        public Builder delimiter(String var1);

        public Builder headerList(Collection<String> var1);

        public Builder headerList(String ... var1);
    }
}

