"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolCallStartEventSchema = exports.ToolCallResultEventSchema = exports.ToolCallEndEventSchema = exports.ToolCallChunkEventSchema = exports.ToolCallArgsEventSchema = exports.ThinkingTextMessageStartEventSchema = exports.ThinkingTextMessageEndEventSchema = exports.ThinkingTextMessageContentEventSchema = exports.ThinkingStartEventSchema = exports.ThinkingEndEventSchema = exports.TextMessageStartEventSchema = exports.TextMessageEndEventSchema = exports.TextMessageContentEventSchema = exports.TextMessageChunkEventSchema = exports.StepStartedEventSchema = exports.StepFinishedEventSchema = exports.StateSnapshotEventSchema = exports.StateDeltaEventSchema = exports.RunStartedEventSchema = exports.RunFinishedEventSchema = exports.RunErrorEventSchema = exports.RawEventSchema = exports.MessagesSnapshotEventSchema = exports.EventType = exports.EventSchemas = exports.CustomEventSchema = exports.BaseEventSchema = void 0;
var _zod = require("zod");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Text messages can have any role except "tool"
const TextMessageRoleSchema = _zod.z.union([_zod.z.literal('developer'), _zod.z.literal('system'), _zod.z.literal('assistant'), _zod.z.literal('user')]);
let EventType = exports.EventType = /*#__PURE__*/function (EventType) {
  EventType["TEXT_MESSAGE_START"] = "TEXT_MESSAGE_START";
  EventType["TEXT_MESSAGE_CONTENT"] = "TEXT_MESSAGE_CONTENT";
  EventType["TEXT_MESSAGE_END"] = "TEXT_MESSAGE_END";
  EventType["TEXT_MESSAGE_CHUNK"] = "TEXT_MESSAGE_CHUNK";
  EventType["THINKING_TEXT_MESSAGE_START"] = "THINKING_TEXT_MESSAGE_START";
  EventType["THINKING_TEXT_MESSAGE_CONTENT"] = "THINKING_TEXT_MESSAGE_CONTENT";
  EventType["THINKING_TEXT_MESSAGE_END"] = "THINKING_TEXT_MESSAGE_END";
  EventType["TOOL_CALL_START"] = "TOOL_CALL_START";
  EventType["TOOL_CALL_ARGS"] = "TOOL_CALL_ARGS";
  EventType["TOOL_CALL_END"] = "TOOL_CALL_END";
  EventType["TOOL_CALL_CHUNK"] = "TOOL_CALL_CHUNK";
  EventType["TOOL_CALL_RESULT"] = "TOOL_CALL_RESULT";
  EventType["THINKING_START"] = "THINKING_START";
  EventType["THINKING_END"] = "THINKING_END";
  EventType["STATE_SNAPSHOT"] = "STATE_SNAPSHOT";
  EventType["STATE_DELTA"] = "STATE_DELTA";
  EventType["MESSAGES_SNAPSHOT"] = "MESSAGES_SNAPSHOT";
  EventType["RAW"] = "RAW";
  EventType["CUSTOM"] = "CUSTOM";
  EventType["RUN_STARTED"] = "RUN_STARTED";
  EventType["RUN_FINISHED"] = "RUN_FINISHED";
  EventType["RUN_ERROR"] = "RUN_ERROR";
  EventType["STEP_STARTED"] = "STEP_STARTED";
  EventType["STEP_FINISHED"] = "STEP_FINISHED";
  return EventType;
}({});
const BaseEventSchema = exports.BaseEventSchema = _zod.z.object({
  type: _zod.z.nativeEnum(EventType),
  timestamp: _zod.z.number().optional(),
  rawEvent: _zod.z.any().optional()
});
const TextMessageStartEventSchema = exports.TextMessageStartEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.TEXT_MESSAGE_START),
  messageId: _zod.z.string(),
  role: TextMessageRoleSchema.default('assistant')
});
const TextMessageContentEventSchema = exports.TextMessageContentEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.TEXT_MESSAGE_CONTENT),
  messageId: _zod.z.string(),
  delta: _zod.z.string().refine(s => s.length > 0, 'Delta must not be an empty string')
});
const TextMessageEndEventSchema = exports.TextMessageEndEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.TEXT_MESSAGE_END),
  messageId: _zod.z.string()
});
const TextMessageChunkEventSchema = exports.TextMessageChunkEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.TEXT_MESSAGE_CHUNK),
  messageId: _zod.z.string().optional(),
  role: TextMessageRoleSchema.optional(),
  delta: _zod.z.string().optional()
});
const ThinkingTextMessageStartEventSchema = exports.ThinkingTextMessageStartEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.THINKING_TEXT_MESSAGE_START)
});
const ThinkingTextMessageContentEventSchema = exports.ThinkingTextMessageContentEventSchema = TextMessageContentEventSchema.omit({
  messageId: true,
  type: true
}).extend({
  type: _zod.z.literal(EventType.THINKING_TEXT_MESSAGE_CONTENT)
});
const ThinkingTextMessageEndEventSchema = exports.ThinkingTextMessageEndEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.THINKING_TEXT_MESSAGE_END)
});
const ToolCallStartEventSchema = exports.ToolCallStartEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.TOOL_CALL_START),
  toolCallId: _zod.z.string(),
  toolCallName: _zod.z.string(),
  parentMessageId: _zod.z.string().optional()
});
const ToolCallArgsEventSchema = exports.ToolCallArgsEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.TOOL_CALL_ARGS),
  toolCallId: _zod.z.string(),
  delta: _zod.z.string()
});
const ToolCallEndEventSchema = exports.ToolCallEndEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.TOOL_CALL_END),
  toolCallId: _zod.z.string()
});
const ToolCallResultEventSchema = exports.ToolCallResultEventSchema = BaseEventSchema.extend({
  messageId: _zod.z.string(),
  type: _zod.z.literal(EventType.TOOL_CALL_RESULT),
  toolCallId: _zod.z.string(),
  content: _zod.z.string(),
  role: _zod.z.literal('tool').optional()
});
const ToolCallChunkEventSchema = exports.ToolCallChunkEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.TOOL_CALL_CHUNK),
  toolCallId: _zod.z.string().optional(),
  toolCallName: _zod.z.string().optional(),
  parentMessageId: _zod.z.string().optional(),
  delta: _zod.z.string().optional()
});
const ThinkingStartEventSchema = exports.ThinkingStartEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.THINKING_START),
  title: _zod.z.string().optional()
});
const ThinkingEndEventSchema = exports.ThinkingEndEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.THINKING_END)
});
const StateSnapshotEventSchema = exports.StateSnapshotEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.STATE_SNAPSHOT),
  snapshot: _types.StateSchema
});
const StateDeltaEventSchema = exports.StateDeltaEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.STATE_DELTA),
  delta: _zod.z.array(_zod.z.any()) // JSON Patch (RFC 6902)
});

const MessagesSnapshotEventSchema = exports.MessagesSnapshotEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.MESSAGES_SNAPSHOT),
  messages: _zod.z.array(_types.MessageSchema)
});
const RawEventSchema = exports.RawEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.RAW),
  event: _zod.z.any(),
  source: _zod.z.string().optional()
});
const CustomEventSchema = exports.CustomEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.CUSTOM),
  name: _zod.z.string(),
  value: _zod.z.any()
});
const RunStartedEventSchema = exports.RunStartedEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.RUN_STARTED),
  threadId: _zod.z.string(),
  runId: _zod.z.string()
});
const RunFinishedEventSchema = exports.RunFinishedEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.RUN_FINISHED),
  threadId: _zod.z.string(),
  runId: _zod.z.string(),
  result: _zod.z.any().optional()
});
const RunErrorEventSchema = exports.RunErrorEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.RUN_ERROR),
  message: _zod.z.string(),
  code: _zod.z.string().optional()
});
const StepStartedEventSchema = exports.StepStartedEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.STEP_STARTED),
  stepName: _zod.z.string()
});
const StepFinishedEventSchema = exports.StepFinishedEventSchema = BaseEventSchema.extend({
  type: _zod.z.literal(EventType.STEP_FINISHED),
  stepName: _zod.z.string()
});
const EventSchemas = exports.EventSchemas = _zod.z.discriminatedUnion('type', [TextMessageStartEventSchema, TextMessageContentEventSchema, TextMessageEndEventSchema, TextMessageChunkEventSchema, ThinkingStartEventSchema, ThinkingEndEventSchema, ThinkingTextMessageStartEventSchema, ThinkingTextMessageContentEventSchema, ThinkingTextMessageEndEventSchema, ToolCallStartEventSchema, ToolCallArgsEventSchema, ToolCallEndEventSchema, ToolCallChunkEventSchema, ToolCallResultEventSchema, StateSnapshotEventSchema, StateDeltaEventSchema, MessagesSnapshotEventSchema, RawEventSchema, CustomEventSchema, RunStartedEventSchema, RunFinishedEventSchema, RunErrorEventSchema, StepStartedEventSchema, StepFinishedEventSchema]);