/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.episodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import mediathek.tool.episodes.RuleBasedTitleParser;
import mediathek.tool.episodes.SeasonEpisode;

public class TitleParserManager {
    private final Map<String, RuleBasedTitleParser> parsers = new HashMap<String, RuleBasedTitleParser>();

    public TitleParserManager() {
        this.register("3Sat", "\\(\\s*[sS](?<season>\\d{4})/[eE](?<episode>\\d{1,2})\\s*\\)", "[sS](?<season>\\d{4})/[eE](?<episode>\\d{1,2})", "[sS](?<season>\\d{4})[eE](?<episode>\\d{1,2})", "\\(\\s*[sS](?<season>\\d{4})-[eE](?<episode>\\d{1,2})\\s*\\)");
        this.register("ARD", "(?<season>\\d{1,2})\\.\\s*Staffel,\\s*(?<episode>\\d{1,3})\\.", "Staffel\\s*(?<season>\\d{1,2})[,\\s]*Folge\\s*(?<episode>\\d{1,3})", "\\(\\s*[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,5})\\s*\\)", "\\(\\s*[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,5})\\s*\\)", "[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,5})");
        this.register("ARD-alpha", "\\(\\s*[sS](?<season>\\d{2})/[eE](?<episode>\\d{2})\\s*\\)", "[sS](?<season>\\d{2})/[eE](?<episode>\\d{2})", "[sS](?<season>\\d{2})[eE](?<episode>\\d{2})");
        this.register("BR", "\\(\\s*[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,2})\\s*\\)", "^(?:\\d{1,3}):[^\\(]*\\(\\s*[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,2})\\s*\\)", "Folge\\s*\\d{1,3}[:\\-][^\\(]*\\(\\s*[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,2})\\s*\\)");
        this.register("HR", "\\(\\s*[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,3})\\s*\\)", "Staffel\\s*(?<season>\\d{1,2})\\s*,\\s*Folge\\s*(?<episode>\\d{1,3})");
        this.register("MDR", "\\(\\s*[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,3})\\s*\\)", "[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,3})");
        this.register("NDR", "\\(\\s*[sS](?<season>\\d{1,3})/[eE](?<episode>\\d{1,2})\\s*\\)");
        this.register("ONE", "(?<season>\\d{1,2})\\.\\s*Staffel,\\s*(?<episode>\\d{1,3})\\.", "Staffel\\s*(?<season>\\d{1,2})[,\\s]*Folge\\s*(?<episode>\\d{1,3})", "\\(\\s*[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,5})\\s*\\)", "\\(\\s*[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,5})\\s*\\)", "[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,5})");
        this.register("RBB", "\\(\\s*[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,2})\\s*\\)", "\\(\\s*(?<season>\\d{1,2})/(?<episode>\\d{1,2})\\s*\\)");
        this.register("SWR", "\\(\\s*[sS](?<season>\\d{1,3})/[eE](?<episode>\\d{1,2})\\s*\\)", "\\(\\s*[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,2})\\s*\\)", "[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,2})", "[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,2})", "Staffel\\s*(?<season>\\d{1,2})\\s*,\\s*Folge\\s*(?<episode>\\d{1,3})");
        this.register("WDR", "\\(\\s*[sS](?<season>\\d{1,3})/[eE](?<episode>\\d{1,2})\\s*\\)", "\\(\\s*[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,2})\\s*\\)", "[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,2})", "[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,2})", "Staffel\\s*(?<season>\\d{1,2})\\s*,\\s*Folge\\s*(?<episode>\\d{1,3})");
        this.register("ZDF", "\\(\\s*[sS](?<season>\\d{1,4})/[eE](?<episode>\\d{1,4})\\s*\\)", "\\(\\s*[sS](?<season>\\d{1,4})[eE](?<episode>\\d{1,4})\\s*\\)", "[sS](?<season>\\d{1,4})/[eE](?<episode>\\d{1,4})", "[sS](?<season>\\d{1,4})[eE](?<episode>\\d{1,4})");
        this.register("ZDFneo", "\\(\\s*[sS](?<season>\\d{1,3})/[eE](?<episode>\\d{1,2})\\s*\\)", "\\(\\s*[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,2})\\s*\\)", "[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,2})", "[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,2})", "Staffel\\s*(?<season>\\d{1,2})\\s*,\\s*Folge\\s*(?<episode>\\d{1,3})");
        this.register("ZDF-tivi", "\\(\\s*[sS](?<season>\\d{1,3})/[eE](?<episode>\\d{1,2})\\s*\\)", "\\(\\s*[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,2})\\s*\\)", "[sS](?<season>\\d{1,2})/[eE](?<episode>\\d{1,2})", "[sS](?<season>\\d{1,2})[eE](?<episode>\\d{1,2})", "Staffel\\s*(?<season>\\d{1,2})\\s*,\\s*Folge\\s*(?<episode>\\d{1,3})");
    }

    public void register(String sender, String ... patterns) {
        ArrayList<Pattern> compiled = new ArrayList<Pattern>();
        for (String regex : patterns) {
            compiled.add(Pattern.compile(regex, 2));
        }
        this.parsers.put(sender, new RuleBasedTitleParser(compiled));
    }

    public Optional<SeasonEpisode> parse(String sender, String title) {
        RuleBasedTitleParser parser = this.parsers.get(sender);
        if (parser == null) {
            return Optional.empty();
        }
        return parser.parse(title);
    }
}

