/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.sql.ast.spi.AbstractSqlAstWalker;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.select.SelectStatement;

public class ColumnReferenceCheckingSqlAstWalker
extends AbstractSqlAstWalker {
    private final String identificationVariable;
    private boolean allColumnReferencesFromIdentificationVariable = true;

    public ColumnReferenceCheckingSqlAstWalker(String identificationVariable) {
        this.identificationVariable = identificationVariable;
    }

    public boolean isAllColumnReferencesFromIdentificationVariable() {
        return this.allColumnReferencesFromIdentificationVariable;
    }

    @Override
    public void visitSelectStatement(SelectStatement statement) {
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        if (this.allColumnReferencesFromIdentificationVariable && !this.identificationVariable.equals(columnReference.getQualifier())) {
            this.allColumnReferencesFromIdentificationVariable = false;
        }
    }

    @Override
    public void visitFilterPredicate(FilterPredicate filterPredicate) {
        this.allColumnReferencesFromIdentificationVariable = false;
    }

    @Override
    public void visitFilterFragmentPredicate(FilterPredicate.FilterFragmentPredicate fragmentPredicate) {
        this.allColumnReferencesFromIdentificationVariable = false;
    }

    @Override
    public void visitSqlFragmentPredicate(SqlFragmentPredicate predicate) {
        this.allColumnReferencesFromIdentificationVariable = false;
    }
}

