/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.Objects;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class NaturalIdCacheKey
implements Serializable {
    private final Object naturalIdValues;
    private final String entityName;
    private final String tenantId;
    private final int hashCode;

    public NaturalIdCacheKey(Object naturalIdValues, String entityName, String tenantId, int hashCode) {
        this.naturalIdValues = naturalIdValues;
        this.entityName = entityName;
        this.tenantId = tenantId;
        this.hashCode = hashCode;
    }

    public static NaturalIdCacheKey from(Object naturalIdValues, EntityPersister persister, String entityName, SharedSessionContractImplementor session) {
        NaturalIdCacheKeyBuilder builder = new NaturalIdCacheKeyBuilder(entityName, session.getTenantIdentifier(), persister);
        NaturalIdCacheKey.addTenantIdToCacheKey(session, builder);
        persister.getNaturalIdMapping().addToCacheKey(builder, naturalIdValues, session);
        return builder.build();
    }

    private static void addTenantIdToCacheKey(SharedSessionContractImplementor session, NaturalIdCacheKeyBuilder builder) {
        Object tenantId = session.getTenantIdentifierValue();
        builder.addHashCode(tenantId == null ? 0 : session.getFactory().getTenantIdentifierJavaType().extractHashCode(tenantId));
    }

    public static NaturalIdCacheKey from(Object naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return NaturalIdCacheKey.from(naturalIdValues, persister, persister.getRootEntityName(), session);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Object getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.hashCode != o.hashCode() || !(o instanceof NaturalIdCacheKey)) {
            return false;
        }
        NaturalIdCacheKey other = (NaturalIdCacheKey)o;
        return Objects.equals(this.entityName, other.entityName) && Objects.equals(this.tenantId, other.tenantId) && Objects.deepEquals(this.naturalIdValues, other.naturalIdValues);
    }

    public String toString() {
        StringBuilder string = new StringBuilder().append(this.entityName).append("##NaturalId[");
        Object object = this.naturalIdValues;
        if (object instanceof Object[]) {
            Object[] values = (Object[])object;
            for (int i = 0; i < values.length; ++i) {
                string.append(values[i]);
                if (i + 1 >= values.length) continue;
                string.append(", ");
            }
        } else {
            string.append(this.naturalIdValues);
        }
        return string.toString();
    }

    private static class NaturalIdCacheKeyBuilder
    implements MutableCacheKeyBuilder {
        private final String entityName;
        private final String tenantIdentifier;
        private final Object[] naturalIdValues;
        private int hashCode;
        private int naturalIdValueIndex;

        public NaturalIdCacheKeyBuilder(String entityName, String tenantIdentifier, EntityPersister persister) {
            this.entityName = entityName;
            this.tenantIdentifier = tenantIdentifier;
            this.naturalIdValues = new Object[persister.getNaturalIdMapping().getJdbcTypeCount()];
        }

        @Override
        public void addValue(Object value) {
            this.naturalIdValues[this.naturalIdValueIndex++] = value;
        }

        @Override
        public void addHashCode(int hashCode) {
            this.hashCode = 37 * this.hashCode + hashCode;
        }

        @Override
        public NaturalIdCacheKey build() {
            return new NaturalIdCacheKey(this.naturalIdValues, this.entityName, this.tenantIdentifier, this.hashCode);
        }
    }
}

