/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.ArrayDeref;
import io.quarkus.gizmo2.impl.ArrayLength;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.BlockHeader;
import io.quarkus.gizmo2.impl.BoundItem;
import io.quarkus.gizmo2.impl.FieldDeref;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.Pop;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import java.util.function.BiFunction;

public abstract class Item
implements Expr {
    protected final String creationSite = Util.trackCaller();

    public String itemName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ClassDesc type() {
        return ConstantDescs.CD_void;
    }

    public boolean bound() {
        return true;
    }

    Node verify(Node node) {
        while (node.item() != BlockHeader.INSTANCE) {
            Item actual = node.item();
            if (this.equals(actual)) {
                return this.forEachDependency(node, Item::verify);
            }
            node = actual.pop(node);
        }
        throw this.missing();
    }

    public Node pop(Node node) {
        assert (this == node.item());
        if (!this.bound()) {
            Node result = this.forEachDependency(node, Item::pop);
            if (result == null) {
                throw new IllegalStateException();
            }
            node.remove();
            return result;
        }
        if (this.isVoid()) {
            Node result = this.forEachDependency(node, Item::verify);
            if (result == null) {
                throw new IllegalStateException();
            }
            return result;
        }
        Pop pop = new Pop(this);
        pop.insert(node.next());
        Node result = this.forEachDependency(node, Item::verify);
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    public Node revoke(Node node) {
        assert (this == node.item());
        Node prev = this.forEachDependency(node, Item::pop);
        this.remove(node);
        return prev;
    }

    protected Node insert(Node node) {
        return node.insertPrev(this);
    }

    protected Node insertIfUnbound(Node node) {
        if (!this.bound()) {
            Node prev = this.forEachDependency(node.insertNext(this), Item::insertIfUnbound);
            this.bind();
            return prev;
        }
        return this.verify(node);
    }

    protected void bind() {
    }

    protected void replace(Node node, Item replacement) {
        assert (this == node.item());
        node.set(replacement);
    }

    protected void remove(Node node) {
        assert (this == node.item());
        node.remove();
    }

    protected Node process(Node node, BiFunction<Item, Node, Node> op) {
        return op.apply(this, node);
    }

    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        if (node == null) {
            throw this.missing();
        }
        return node.prev();
    }

    private IllegalStateException missing() {
        if (this.creationSite == null) {
            return new IllegalStateException("Item " + String.valueOf(this) + " is not at its expected location (declare a LocalVar to store values which are used away from their creation site)\nTo track callers and get an improved exception message, add the system property `gizmo.debug`");
        }
        return new IllegalStateException("Item " + String.valueOf(this) + " created at " + this.creationSite + " is not at its expected location (declare a LocalVar to store values which are used away from their creation site)");
    }

    public abstract void writeCode(CodeBuilder var1, BlockCreatorImpl var2);

    public void writeAnnotations(RetentionPolicy retention, ArrayList<TypeAnnotation> annotations) {
    }

    public boolean mayFallThrough() {
        return true;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder b) {
        this.toShortString(b);
        return b;
    }

    public StringBuilder toShortString(StringBuilder b) {
        return b.append(this.itemName());
    }

    @Override
    public Assignable elem(Expr index) {
        if (!this.type().isArray()) {
            throw new IllegalArgumentException("Value type is not array: " + this.type().displayName());
        }
        return new ArrayDeref(this, ((GenericType.OfArray)this.genericType()).componentType(), index);
    }

    @Override
    public Expr length() {
        if (!this.type().isArray()) {
            throw new IllegalArgumentException("Value type is not array: " + this.type().displayName());
        }
        return new ArrayLength(this);
    }

    @Override
    public InstanceFieldVar field(FieldDesc desc, GenericType genericType) {
        Assert.checkNotNullParam((String)"desc", (Object)desc);
        Assert.checkNotNullParam((String)"genericType", (Object)genericType);
        if (!desc.type().equals(genericType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match field type %s".formatted(genericType, desc.type()));
        }
        return new FieldDeref(this, desc, genericType);
    }

    Item asBound() {
        return this.bound() ? this : new BoundItem(this);
    }
}

