/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ArcDecorationPainter
implements SubstanceDecorationPainter {
    public static final String DISPLAY_NAME = "Arc";

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        switch (decorationAreaType) {
            case PRIMARY_TITLE_PANE: 
            case SECONDARY_TITLE_PANE: {
                this.paintTitleBackground(graphics, comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
                break;
            }
            default: {
                this.paintExtraBackground(graphics, SubstanceCoreUtilities.getHeaderParent(comp), comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
            }
        }
    }

    private void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, SubstanceColorScheme scheme) {
        BufferedImage rectangular = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D rgraphics = (Graphics2D)rectangular.getGraphics();
        GeneralPath clipTop = new GeneralPath();
        clipTop.moveTo(0.0f, 0.0f);
        clipTop.lineTo(width, 0.0f);
        clipTop.lineTo(width, height / 2);
        clipTop.quadTo(width / 2, height / 4, 0.0f, height / 2);
        clipTop.lineTo(0.0f, 0.0f);
        rgraphics.setClip(clipTop);
        LinearGradientPaint gradientTop = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{scheme.getLightColor(), scheme.getUltraLightColor(), scheme.getLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
        rgraphics.setPaint(gradientTop);
        rgraphics.fillRect(0, 0, width, height);
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, height / 2);
        clipBottom.quadTo(width / 2, height / 4, 0.0f, height / 2);
        clipBottom.lineTo(0.0f, height);
        rgraphics.setClip(clipBottom);
        LinearGradientPaint gradientBottom = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{scheme.getMidColor(), scheme.getLightColor(), scheme.getMidColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
        rgraphics.setPaint(gradientBottom);
        rgraphics.fillRect(0, 0, width, height);
        GeneralPath mid = new GeneralPath();
        mid.moveTo(width, height / 2);
        mid.quadTo(width / 2, height / 4, 0.0f, height / 2);
        rgraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rgraphics.setClip(new Rectangle(0, 0, width, height));
        rgraphics.draw(mid);
        graphics.drawImage((Image)rectangular, 0, 0, null);
    }

    private void paintExtraBackground(Graphics2D graphics, Container parent, Component comp, int width, int height, SubstanceColorScheme scheme) {
        int pWidth;
        JRootPane rootPane = SwingUtilities.getRootPane(parent);
        int dx = 0;
        JComponent titlePane = null;
        if (rootPane != null && (titlePane = SubstanceCoreUtilities.getTitlePane(rootPane)) != null) {
            if (comp.isShowing() && titlePane.isShowing()) {
                dx += comp.getLocationOnScreen().x - titlePane.getLocationOnScreen().x;
            } else {
                Component c;
                dx = 0;
                for (c = comp; c != rootPane; c = c.getParent()) {
                    dx += c.getX();
                }
                for (c = titlePane; c != rootPane; c = c.getParent()) {
                    dx -= c.getX();
                }
            }
        }
        int n = pWidth = titlePane == null ? parent.getWidth() : titlePane.getWidth();
        if (pWidth != 0) {
            LinearGradientPaint gradientBottom = new LinearGradientPaint(-dx, 0.0f, -dx + pWidth, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{scheme.getMidColor(), scheme.getLightColor(), scheme.getMidColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setPaint(gradientBottom);
            g2d.fillRect(-dx, 0, pWidth, height);
            g2d.dispose();
        }
    }
}

