---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Mailgun public verification key'
---

## Description

The response body contains content that matches the pattern of a Mailgun public verification key was identified. These keys are deprecated and you should use the v4 verification service instead. A malicious with access to this key can use it to validate email addresses.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate your public verification key:

- Sign in to your Mailgun account and access the dashboard at <https://app.mailgun.com/>
- On the top right-hand side, select your account profile and then select "API Security"
- In the "Verification public key" section, select the rotate arrow icon in the right-hand side
- When prompted, select "Reset Key" in the "Reset public verification key" dialog

For more information, please see [Mailgun's documentation on API keys](https://mailchimp.com/help/about-api-keys).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.73 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
