/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.permissions.PermUtil;
import org.knopflerfish.framework.permissions.PermissionsWrapper;
import org.osgi.service.permissionadmin.PermissionInfo;

class PermissionInfoStorage {
    static final String DEFAULTPERM = "(java.security.AllPermission)";
    private PermissionInfo[] initialDefault = null;
    private final File permDir;
    private long lastPermFile;
    private final HashMap<String, Element> permissions = new HashMap();
    private PermissionInfo[] defaultPermissions;
    private final HashMap<String, ArrayList<PermissionsWrapper>> defaultInvalidateCallbacks = new HashMap();
    private final Debug debug;
    final boolean readOnly;

    public PermissionInfoStorage(FrameworkContext ctx) {
        this.debug = ctx.debug;
        this.initialDefault = new PermissionInfo[]{new PermissionInfo(DEFAULTPERM)};
        this.defaultPermissions = this.initialDefault;
        this.readOnly = ctx.props.getBooleanProperty("org.knopflerfish.framework.readonly");
        this.permDir = Util.getFileStorage(ctx, "perms", !this.readOnly);
        if (this.permDir == null) {
            System.err.println("Property org.osgi.framework.dir not set,permission data will not be saved between sessions");
        } else if (this.permDir.isDirectory()) {
            this.load();
        }
    }

    synchronized PermissionInfo[] get(String location, PermissionsWrapper callInvalidate) {
        Element res = this.permissions.get(location);
        if (res != null) {
            if (callInvalidate != null) {
                if (res.invalidateCallback == null) {
                    res.invalidateCallback = new ArrayList(2);
                }
                res.invalidateCallback.add(callInvalidate);
            }
            return res.pi;
        }
        return null;
    }

    synchronized PermissionInfo[] getDefault(PermissionsWrapper callInvalidate) {
        if (callInvalidate != null && callInvalidate.location != null) {
            ArrayList<PermissionsWrapper> cil = this.defaultInvalidateCallbacks.get(callInvalidate.location);
            if (cil == null) {
                cil = new ArrayList(2);
                this.defaultInvalidateCallbacks.put(callInvalidate.location, cil);
            }
            cil.add(callInvalidate);
        }
        return this.defaultPermissions;
    }

    synchronized String[] getKeys() {
        int size = this.permissions.size();
        if (size == 0) {
            return null;
        }
        String[] res = new String[size];
        int ix = 0;
        for (String string : this.permissions.keySet()) {
            res[ix++] = string;
        }
        return res;
    }

    synchronized void put(String location, PermissionInfo[] perms) {
        ArrayList<PermissionsWrapper> vpw;
        Element old = this.permissions.put(location, new Element(perms));
        this.save(location, perms);
        ArrayList<PermissionsWrapper> arrayList = vpw = old != null ? old.invalidateCallback : this.defaultInvalidateCallbacks.remove(location);
        if (vpw != null) {
            for (PermissionsWrapper permissionsWrapper : vpw) {
                permissionsWrapper.invalidate();
            }
        }
    }

    synchronized void putDefault(PermissionInfo[] permissions) {
        this.defaultPermissions = permissions != null ? permissions : this.initialDefault;
        this.save(null, this.defaultPermissions);
        for (ArrayList<PermissionsWrapper> pws : this.defaultInvalidateCallbacks.values()) {
            for (PermissionsWrapper pw : pws) {
                pw.invalidate();
            }
        }
        this.defaultInvalidateCallbacks.clear();
    }

    synchronized void remove(String location) {
        Element old = this.permissions.remove(location);
        this.save(location, null);
        if (old != null && old.invalidateCallback != null) {
            for (PermissionsWrapper permissionsWrapper : old.invalidateCallback) {
                permissionsWrapper.invalidate();
            }
        }
    }

    synchronized void purgeCallback(PermissionCollection pc) {
        PermissionsWrapper pw = (PermissionsWrapper)pc;
        Element e = this.permissions.get(pw.location);
        if (e != null && e.invalidateCallback != null && e.invalidateCallback.remove(pw)) {
            if (e.invalidateCallback.isEmpty()) {
                e.invalidateCallback = null;
            }
        } else {
            ArrayList<PermissionsWrapper> cil = this.defaultInvalidateCallbacks.get(pw.location);
            if (cil != null && cil.remove(pw) && cil.isEmpty()) {
                this.defaultInvalidateCallbacks.remove(pw);
            }
        }
    }

    private void save(final String location, final PermissionInfo[] perms) {
        if (this.permDir != null && !this.readOnly) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    String loc;
                    File f;
                    if (location != null) {
                        if (PermissionInfoStorage.this.lastPermFile % 20L == 0L) {
                            PermissionInfoStorage.this.purge();
                        }
                        f = new File(PermissionInfoStorage.this.permDir, Long.toString(++PermissionInfoStorage.this.lastPermFile));
                        loc = location;
                    } else {
                        f = new File(PermissionInfoStorage.this.permDir, "default");
                        loc = "defaultPermissions";
                    }
                    BufferedWriter out = null;
                    try {
                        int p;
                        out = new BufferedWriter(new FileWriter(f));
                        while ((p = loc.indexOf(10)) != -1) {
                            out.write(loc.substring(0, ++p) + " ");
                            loc = loc.substring(p);
                        }
                        out.write(loc + "\n\n");
                        if (perms != null) {
                            for (PermissionInfo perm : perms) {
                                out.write(perm.getEncoded() + "\n");
                            }
                        } else {
                            out.write("NULL\n");
                        }
                        out.write("\n");
                        out.close();
                    }
                    catch (IOException e) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException ignore) {
                                // empty catch block
                            }
                            f.delete();
                        }
                        PermissionInfoStorage.this.debug.printStackTrace("NYI! Report error", e);
                    }
                    return null;
                }
            });
        }
    }

    private void load() {
        File[] files;
        for (File file : files = PermUtil.getSortedFiles(this.permDir)) {
            this.load(file);
        }
        try {
            this.lastPermFile = Long.parseLong(files[files.length - 1].getName());
        }
        catch (Exception e) {
            this.lastPermFile = -1L;
        }
    }

    private void load(File fh) {
        BufferedReader in = null;
        boolean isDefault = "default".equals(fh.getName());
        try {
            in = new BufferedReader(new FileReader(fh));
            String loc = this.parseLocation(in);
            ArrayList<PermissionInfo> piv = new ArrayList<PermissionInfo>();
            int c = in.read();
            while (c != -1) {
                StringBuffer pe = new StringBuffer();
                while (c != -1 && c != 10) {
                    pe.append((char)c);
                    c = in.read();
                }
                String line = pe.toString();
                if ("NULL".equals(line)) {
                    if (isDefault) {
                        this.defaultPermissions = null;
                    } else {
                        this.permissions.remove(loc);
                    }
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    return;
                }
                if ("".equals(line)) break;
                piv.add(new PermissionInfo(line));
                c = in.read();
            }
            if (c == -1) {
                throw new IOException("Premature EOF when parsing permission file: " + fh.getName());
            }
            if (in.read() != -1) {
                throw new IOException("Garbage at end of file when parsing permission file: " + fh.getName());
            }
            in.close();
            PermissionInfo[] pi = new PermissionInfo[piv.size()];
            piv.toArray(pi);
            if (isDefault) {
                this.defaultPermissions = pi;
            } else {
                this.permissions.put(loc, new Element(pi));
            }
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            this.debug.printStackTrace("NYI! Report error", e);
        }
    }

    private String parseLocation(Reader in) throws IOException {
        char cc;
        int c;
        StringBuffer loc = new StringBuffer();
        while ((c = in.read()) != -1 && ((cc = (char)c) != '\n' || (c = in.read()) == 32)) {
            loc.append(cc);
        }
        return loc.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        HashMap<String, Boolean> foundTwo = new HashMap<String, Boolean>();
        File[] files = PermUtil.getSortedFiles(this.permDir);
        for (int i = files.length - 1; i >= 0; --i) {
            String loc;
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(files[i]));
                loc = this.parseLocation(in);
            }
            catch (IOException ignore) {
                files[i].delete();
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            Boolean v = (Boolean)foundTwo.get(loc);
            if (v != null) {
                if (v.booleanValue()) {
                    files[i].delete();
                    continue;
                }
                foundTwo.put(loc, new Boolean(true));
                continue;
            }
            foundTwo.put(loc, new Boolean(false));
        }
    }

    static class Element {
        PermissionInfo[] pi;
        ArrayList<PermissionsWrapper> invalidateCallback = null;

        Element(PermissionInfo[] pi) {
            this.pi = pi;
        }
    }
}

