/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerConstants;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabaseTrigger;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExecutionContext;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.DBSQLException;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LongKeyMap;

public class SQLServerDatabase
implements DBSCatalog,
DBPSaveableObject,
DBPRefreshableObject,
DBPSystemObject,
DBPNamedObject2,
DBPObjectStatistics {
    private static final Log log = Log.getLog(SQLServerDatabase.class);
    private final SQLServerDataSource dataSource;
    private final long databaseId;
    private boolean persisted;
    private String name;
    private String description;
    private DataTypeCache typesCache = new DataTypeCache();
    private SchemaCache schemaCache = new SchemaCache();
    private TriggerCache triggerCache = new TriggerCache();
    private Long databaseTotalSize;

    SQLServerDatabase(@NotNull JDBCSession session, @NotNull SQLServerDataSource dataSource, @NotNull JDBCResultSet resultSet, @NotNull String name) {
        this.dataSource = dataSource;
        this.databaseId = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"database_id");
        this.name = name;
        this.persisted = true;
        if (CommonUtils.equalObjects((Object)((SQLServerExecutionContext)session.getExecutionContext()).getActiveDatabaseName(), (Object)this.name)) {
            try {
                this.getSchemas(session.getProgressMonitor());
            }
            catch (DBException e) {
                log.debug((Object)"Error reading default database schemas", (Throwable)e);
            }
        }
    }

    public SQLServerDatabase(SQLServerDataSource dataSource) {
        this.dataSource = dataSource;
        this.databaseId = 0L;
        this.persisted = false;
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getDatabaseId() {
        return this.databaseId;
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean isSystem() {
        SQLServerDatabase defaultDatabase = this.dataSource.getDefaultDatabase((DBRProgressMonitor)new VoidProgressMonitor());
        return ArrayUtils.contains((Object[])SQLServerConstants.SYSTEM_DATABASES, (Object)this.name) && !CommonUtils.equalObjects((Object)this, (Object)defaultDatabase);
    }

    public DataTypeCache getDataTypesCache() {
        return this.typesCache;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.typesCache.clearCache();
        this.schemaCache.clearCache();
        this.triggerCache.clearCache();
        this.databaseTotalSize = null;
        return this;
    }

    void refreshDataTypes() {
        this.typesCache.clearCache();
    }

    @Association
    public Collection<SQLServerDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.typesCache.getAllObjects(monitor, (DBSObject)this);
    }

    public SQLServerDataType getDataType(DBRProgressMonitor monitor, String typeName) throws DBException {
        return (SQLServerDataType)this.typesCache.getObject(monitor, (DBSObject)this, typeName);
    }

    SQLServerDataType getDataTypeByUserTypeId(DBRProgressMonitor monitor, int typeID) throws DBException {
        SQLServerDataType dataType;
        try {
            this.typesCache.getAllObjects(monitor, (DBSObject)this);
            dataType = this.typesCache.getDataType(typeID);
            if (dataType != null) {
                return dataType;
            }
        }
        catch (DBException e) {
            log.error((Object)"Error reading database data types", (Throwable)e);
        }
        dataType = this.dataSource.getSystemDataType(typeID);
        if (dataType != null) {
            return dataType;
        }
        log.debug((Object)("Data type '" + typeID + "' not found in database " + this.getName()));
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public boolean hasStatistics() {
        return this.databaseTotalSize != null;
    }

    public long getStatObjectSize() {
        return this.databaseTotalSize == null ? 0L : this.databaseTotalSize;
    }

    void setDatabaseTotalSize(long databaseTotalSize) {
        this.databaseTotalSize = databaseTotalSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    @Association
    public Collection<SQLServerSchema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        return this.getChildren(monitor);
    }

    public SQLServerSchema getSchema(DBRProgressMonitor monitor, long schemaId) throws DBException {
        for (SQLServerSchema schema : this.getSchemas(monitor)) {
            if (schema.getObjectId() != schemaId) continue;
            return schema;
        }
        if (!monitor.isCanceled()) {
            log.debug((Object)("Schema '" + schemaId + "' not found"));
        }
        return null;
    }

    public SQLServerSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (SQLServerSchema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    public SQLServerSchema getSchema(String name) {
        return (SQLServerSchema)this.schemaCache.getCachedObject(name);
    }

    public SQLServerSchema getSysSchema(DBRProgressMonitor monitor) throws DBException {
        for (SQLServerSchema schema : this.getSchemas(monitor)) {
            if (!schema.getName().equalsIgnoreCase("sys")) continue;
            return schema;
        }
        if (!monitor.isCanceled()) {
            log.debug((Object)"System schema not found");
        }
        return null;
    }

    public Collection<SQLServerSchema> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        try {
            return this.schemaCache.getAllObjects(monitor, (DBSObject)this);
        }
        catch (DBSQLException exception) {
            throw SQLServerUtils.mapException((DBException)((Object)exception));
        }
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.schemaCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) {
        return SQLServerSchema.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<SQLServerDatabaseTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        try {
            return this.triggerCache.getAllObjects(monitor, (DBSObject)this);
        }
        catch (DBSQLException exception) {
            throw SQLServerUtils.mapException((DBException)((Object)exception));
        }
    }

    TriggerCache getTriggerCache() {
        return this.triggerCache;
    }

    private class DataTypeCache
    extends JDBCObjectCache<SQLServerDatabase, SQLServerDataType> {
        private final LongKeyMap<SQLServerDataType> dataTypeMap = new LongKeyMap();

        private DataTypeCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerDatabase database) throws SQLException {
            String statement = database.getDataSource().isSynapseDatabase() ? "SELECT * FROM " + SQLServerUtils.getSystemTableName(database, "types") + " WHERE is_user_defined = 1" : "SELECT ss.*, tt.type_table_object_id,tto.schema_id as type_table_schema_id\nFROM " + SQLServerUtils.getSystemTableName(database, "types") + " ss\nLEFT JOIN " + SQLServerUtils.getSystemTableName(database, "table_types") + " tt ON ss.name = tt.name AND ss.user_type_id = tt.user_type_id\nLEFT OUTER JOIN " + SQLServerUtils.getSystemTableName(database, "objects") + " tto ON tto.object_id = tt.type_table_object_id\nWHERE ss.is_user_defined = 1";
            return session.prepareStatement(statement);
        }

        protected SQLServerDataType fetchObject(@NotNull JDBCSession session, @NotNull SQLServerDatabase database, @NotNull JDBCResultSet resultSet) {
            return new SQLServerDataType((DBSObject)database, (ResultSet)resultSet);
        }

        SQLServerDataType getDataType(long typeID) {
            return (SQLServerDataType)this.dataTypeMap.get(typeID);
        }

        public void clearCache() {
            super.clearCache();
            this.dataTypeMap.clear();
        }

        public void removeObject(@NotNull SQLServerDataType object, boolean resetFullCache) {
            super.removeObject((DBSObject)object, resetFullCache);
            this.dataTypeMap.remove(object.getObjectId());
        }

        public void cacheObject(@NotNull SQLServerDataType object) {
            super.cacheObject((DBSObject)object);
            this.dataTypeMap.put(object.getObjectId(), (Object)object);
        }

        public void setCache(@NotNull List<SQLServerDataType> cache) {
            super.setCache(cache);
            for (SQLServerDataType dt : cache) {
                this.dataTypeMap.put(dt.getObjectId(), (Object)dt);
            }
        }
    }

    static class SchemaCache
    extends JDBCObjectCache<SQLServerDatabase, SQLServerSchema> {
        SchemaCache() {
            this.setListOrderComparator(DBUtils.nameComparatorIgnoreCase());
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerDatabase owner) throws SQLException {
            DBSObjectFilter schemaFilters;
            SQLServerDataSource dataSource = owner.getDataSource();
            boolean showAllSchemas = SQLServerUtils.isShowAllSchemas((DBPDataSource)dataSource);
            String sysSchema = SQLServerUtils.getSystemSchemaFQN(dataSource, owner.getName(), "sys");
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            if (!showAllSchemas) {
                sql.append("DISTINCT ");
            }
            sql.append("s.*,ep.value as description FROM ");
            if (SQLServerUtils.isDriverBabelfish(dataSource.getContainer().getDriver())) {
                sql.append("(SELECT CAST(ext.orig_name AS sysname) AS name, base.oid AS schema_id, base.nspowner AS principal_id FROM pg_namespace base JOIN babelfish_namespace_ext ext ON base.nspname = ext.nspname JOIN babelfish_sysdatabases dbs ON dbs.dbid = ext.dbid WHERE dbs.name = '" + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)owner.getName()) + "') AS s");
            } else {
                sql.append(sysSchema).append(".schemas s");
            }
            sql.append("\nLEFT OUTER JOIN ").append(SQLServerUtils.getExtendedPropsTableName(owner)).append(" ep ON ep.class=").append(SQLServerObjectClass.SCHEMA.getClassId()).append(" AND ep.major_id=s.schema_id AND ep.minor_id=0 AND ep.name='").append("MS_Description").append("'");
            if (!showAllSchemas) {
                sql.append("\nINNER JOIN ").append(sysSchema).append(".");
                if (dataSource.isServerVersionAtLeast(10, 0)) {
                    sql.append("all_objects o ").append("ON s.schema_id=o.schema_id");
                } else {
                    sql.append("sysobjects o ").append("ON s.schema_id=o.uid");
                }
            }
            if ((schemaFilters = dataSource.getContainer().getObjectFilter(SQLServerSchema.class, (DBSObject)owner, false)) != null && schemaFilters.isEnabled()) {
                sql.append("\n");
                JDBCUtils.appendFilterClause((StringBuilder)sql, (DBSObjectFilter)schemaFilters, (String)"s.name", (boolean)true, (DBPDataSource)owner.getDataSource());
            }
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (schemaFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)schemaFilters);
            }
            return dbStat;
        }

        protected SQLServerSchema fetchObject(@NotNull JDBCSession session, @NotNull SQLServerDatabase owner, @NotNull JDBCResultSet resultSet) {
            return new SQLServerSchema(owner, resultSet);
        }
    }

    class TriggerCache
    extends JDBCObjectLookupCache<SQLServerDatabase, SQLServerDatabaseTrigger> {
        TriggerCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull SQLServerDatabase database, @Nullable SQLServerDatabaseTrigger object, @Nullable String objectName) throws SQLException {
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT t.* FROM \n").append(SQLServerUtils.getSystemTableName(database, "triggers")).append(" t");
            sql.append("\nWHERE t.parent_id=0");
            if (object != null || objectName != null) {
                sql.append(" AND t.name=?");
            }
            sql.append("\nORDER BY t.name");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (object != null || objectName != null) {
                dbStat.setString(1, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected SQLServerDatabaseTrigger fetchObject(@NotNull JDBCSession session, @NotNull SQLServerDatabase database, @NotNull JDBCResultSet resultSet) {
            return new SQLServerDatabaseTrigger(database, (ResultSet)resultSet);
        }
    }
}

