/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraintColumn;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVModelSerializer;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

@Deprecated
class DBVModelSerializerLegacy
implements DBVModelSerializer {
    private static final Log log = Log.getLog(DBVModelSerializerLegacy.class);

    DBVModelSerializerLegacy() {
    }

    static void serializeContainer(@NotNull XMLBuilder xml, @NotNull DBVContainer object) throws IOException {
        if (!object.hasValuableData()) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLBuilder.Element ignored = xml.startElement("container");){
            xml.addAttribute("name", object.getName());
            for (DBVContainer container : object.getContainers()) {
                DBVModelSerializerLegacy.serializeContainer(xml, container);
            }
            for (DBVEntity entity : object.getEntities()) {
                if (!entity.hasValuableData()) continue;
                DBVModelSerializerLegacy.serializeEntity(xml, entity);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void serializeEntity(@NotNull XMLBuilder xml, @NotNull DBVEntity entity) throws IOException {
        block162: {
            Throwable throwable = null;
            Object var3_4 = null;
            try (XMLBuilder.Element ignored0 = xml.startElement("entity");){
                XMLBuilder.Element ignored;
                Object var18_66;
                Throwable throwable2;
                Object[] objectArray;
                Object ignored632;
                Object object;
                Object var8_16;
                Throwable throwable4;
                xml.addAttribute("name", entity.getName());
                if (!CommonUtils.isEmpty((String)entity.getDescriptionColumnNames())) {
                    xml.addAttribute("description", entity.getDescriptionColumnNames());
                }
                if (!CommonUtils.isEmpty(entity.getProperties())) {
                    for (Map.Entry<String, Object> prop : entity.getProperties().entrySet()) {
                        throwable4 = null;
                        var8_16 = null;
                        try (XMLBuilder.Element ignored2 = xml.startElement("property");){
                            xml.addAttribute("name", prop.getKey());
                            xml.addAttribute("value", CommonUtils.toString((Object)prop.getValue()));
                        }
                        catch (Throwable throwable5) {
                            if (throwable4 == null) {
                                throwable4 = throwable5;
                            } else if (throwable4 != throwable5) {
                                throwable4.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        }
                    }
                }
                for (DBVEntityAttribute attr : CommonUtils.safeCollection(entity.getEntityAttributes())) {
                    if (!attr.hasValuableData()) continue;
                    throwable4 = null;
                    var8_16 = null;
                    try (XMLBuilder.Element ignored3 = xml.startElement("attribute");){
                        Map<String, Object> transformOptions232;
                        xml.addAttribute("name", attr.getName());
                        DBVTransformSettings transformSettings = attr.getTransformSettings();
                        if (transformSettings != null && transformSettings.hasValuableData()) {
                            Throwable throwable3 = null;
                            object = null;
                            try {
                                ignored632 = xml.startElement("transform");
                                try {
                                    XMLBuilder.Element ignored5;
                                    if (!CommonUtils.isEmpty((String)transformSettings.getCustomTransformer())) {
                                        xml.addAttribute("custom", transformSettings.getCustomTransformer());
                                    }
                                    for (String id : CommonUtils.safeCollection(transformSettings.getIncludedTransformers())) {
                                        objectArray = null;
                                        throwable2 = null;
                                        try {
                                            ignored5 = xml.startElement("include");
                                            try {
                                                xml.addAttribute("id", id);
                                            }
                                            finally {
                                                if (ignored5 != null) {
                                                    ignored5.close();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable5) {
                                            if (objectArray == null) {
                                                objectArray = throwable5;
                                            } else if (objectArray != throwable5) {
                                                objectArray.addSuppressed(throwable5);
                                            }
                                            throw objectArray;
                                        }
                                    }
                                    for (String id : CommonUtils.safeCollection(transformSettings.getExcludedTransformers())) {
                                        objectArray = null;
                                        throwable2 = null;
                                        try {
                                            ignored5 = xml.startElement("exclude");
                                            try {
                                                xml.addAttribute("id", id);
                                            }
                                            finally {
                                                if (ignored5 != null) {
                                                    ignored5.close();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable6) {
                                            if (objectArray == null) {
                                                objectArray = throwable6;
                                            } else if (objectArray != throwable6) {
                                                objectArray.addSuppressed(throwable6);
                                            }
                                            throw objectArray;
                                        }
                                    }
                                    transformOptions232 = transformSettings.getTransformOptions();
                                    if (transformOptions232 != null) {
                                        for (Map.Entry entry : transformOptions232.entrySet()) {
                                            throwable2 = null;
                                            var18_66 = null;
                                            try (XMLBuilder.Element ignored52 = xml.startElement("property");){
                                                if (entry.getValue() == null) continue;
                                                xml.addAttribute("name", (String)entry.getKey());
                                                xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
                                            }
                                            catch (Throwable throwable7) {
                                                if (throwable2 == null) {
                                                    throwable2 = throwable7;
                                                } else if (throwable2 != throwable7) {
                                                    throwable2.addSuppressed(throwable7);
                                                }
                                                throw throwable2;
                                            }
                                        }
                                    }
                                }
                                finally {
                                    if (ignored632 != null) {
                                        ignored632.close();
                                    }
                                }
                            }
                            catch (Throwable throwable8) {
                                void var11_28;
                                if (throwable3 == null) {
                                    Throwable throwable9 = throwable8;
                                } else if (throwable3 != throwable8) {
                                    throwable3.addSuppressed(throwable8);
                                }
                                throw var11_28;
                            }
                        }
                        if (CommonUtils.isEmpty(attr.getProperties())) continue;
                        for (Map.Entry<String, Object> entry : attr.getProperties().entrySet()) {
                            ignored632 = null;
                            transformOptions232 = null;
                            try (XMLBuilder.Element element = xml.startElement("property");){
                                xml.addAttribute("name", entry.getKey());
                                xml.addAttribute("value", CommonUtils.toString((Object)entry.getValue()));
                            }
                            catch (Throwable transformOptions232) {
                                if (ignored632 == null) {
                                    ignored632 = transformOptions232;
                                } else if (ignored632 != transformOptions232) {
                                    ((Throwable)ignored632).addSuppressed(transformOptions232);
                                }
                                throw ignored632;
                            }
                        }
                    }
                    catch (Throwable throwable10) {
                        if (throwable4 == null) {
                            throwable4 = throwable10;
                        } else if (throwable4 != throwable10) {
                            throwable4.addSuppressed(throwable10);
                        }
                        throw throwable4;
                    }
                }
                for (DBVEntityConstraint c : CommonUtils.safeCollection(entity.getConstraints())) {
                    if (!c.hasAttributes()) continue;
                    throwable4 = null;
                    var8_16 = null;
                    try {
                        ignored = xml.startElement("constraint");
                        try {
                            xml.addAttribute("name", c.getName());
                            xml.addAttribute("type", c.getConstraintType().getName());
                            for (DBVEntityConstraintColumn cc : CommonUtils.safeCollection(c.getAttributeReferences(null))) {
                                object = null;
                                ignored632 = null;
                                try (XMLBuilder.Element ignored2 = xml.startElement("attribute");){
                                    xml.addAttribute("name", cc.getAttributeName());
                                }
                                catch (Throwable ignored632) {
                                    if (object == null) {
                                        object = ignored632;
                                    } else if (object != ignored632) {
                                        ((Throwable)object).addSuppressed(ignored632);
                                    }
                                    throw object;
                                }
                            }
                        }
                        finally {
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                    }
                    catch (Throwable throwable11) {
                        if (throwable4 == null) {
                            throwable4 = throwable11;
                        } else if (throwable4 != throwable11) {
                            throwable4.addSuppressed(throwable11);
                        }
                        throw throwable4;
                    }
                }
                for (DBVEntityForeignKey fk : CommonUtils.safeCollection(entity.getForeignKeys())) {
                    throwable4 = null;
                    var8_16 = null;
                    try {
                        ignored = xml.startElement("association");
                        try {
                            DBSEntityConstraint dBSEntityConstraint;
                            DBSEntity refEntity = fk.getAssociatedEntity();
                            if (refEntity != null) {
                                xml.addAttribute("entity", DBUtils.getObjectFullId(refEntity));
                            }
                            if ((dBSEntityConstraint = fk.getReferencedConstraint()) != null) {
                                xml.addAttribute("constraint", dBSEntityConstraint.getName());
                            }
                            for (DBVEntityForeignKeyColumn cc : CommonUtils.safeCollection(fk.getAttributes())) {
                                Throwable throwable10 = null;
                                Object var15_55 = null;
                                try (XMLBuilder.Element ignored2 = xml.startElement("attribute");){
                                    xml.addAttribute("name", cc.getAttributeName());
                                }
                                catch (Throwable throwable11) {
                                    if (throwable10 == null) {
                                        throwable10 = throwable11;
                                    } else if (throwable10 != throwable11) {
                                        throwable10.addSuppressed(throwable11);
                                    }
                                    throw throwable10;
                                }
                            }
                        }
                        finally {
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                    }
                    catch (Throwable throwable14) {
                        if (throwable4 == null) {
                            throwable4 = throwable14;
                        } else if (throwable4 != throwable14) {
                            throwable4.addSuppressed(throwable14);
                        }
                        throw throwable4;
                    }
                }
                if (CommonUtils.isEmpty(entity.getColorOverrides())) break block162;
                Throwable throwable15 = null;
                Iterator<Map.Entry<String, Object>> iterator = null;
                try (XMLBuilder.Element ignored3 = xml.startElement("colors");){
                    for (DBVColorOverride color : entity.getColorOverrides()) {
                        Throwable throwable16 = null;
                        Object var11_35 = null;
                        try (XMLBuilder.Element ignored2 = xml.startElement("color");){
                            xml.addAttribute("name", color.getAttributeName());
                            xml.addAttribute("operator", color.getOperator().name());
                            if (color.isRange()) {
                                xml.addAttribute("range", true);
                            }
                            if (color.isSingleColumn()) {
                                xml.addAttribute("singleColumn", true);
                            }
                            if (color.getColorForeground() != null) {
                                xml.addAttribute("foreground", color.getColorForeground());
                            }
                            if (color.getColorForeground2() != null) {
                                xml.addAttribute("foreground2", color.getColorForeground2());
                            }
                            if (color.getColorBackground() != null) {
                                xml.addAttribute("background", color.getColorBackground());
                            }
                            if (color.getColorBackground2() != null) {
                                xml.addAttribute("background2", color.getColorBackground2());
                            }
                            if (ArrayUtils.isEmpty((Object[])color.getAttributeValues())) continue;
                            objectArray = color.getAttributeValues();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object value = objectArray[n2];
                                if (value != null) {
                                    throwable2 = null;
                                    var18_66 = null;
                                    try (XMLBuilder.Element ignored32 = xml.startElement("value");){
                                        xml.addText((CharSequence)GeneralUtils.serializeObject(value));
                                    }
                                    catch (Throwable throwable12) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable12;
                                        } else if (throwable2 != throwable12) {
                                            throwable2.addSuppressed(throwable12);
                                        }
                                        throw throwable2;
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (Throwable throwable13) {
                            if (throwable16 == null) {
                                throwable16 = throwable13;
                            } else if (throwable16 != throwable13) {
                                throwable16.addSuppressed(throwable13);
                            }
                            throw throwable16;
                        }
                    }
                }
                catch (Throwable throwable19) {
                    if (throwable15 == null) {
                        throwable15 = throwable19;
                    } else if (throwable15 != throwable19) {
                        throwable15.addSuppressed(throwable19);
                    }
                    throw throwable15;
                }
            }
            catch (Throwable throwable20) {
                if (throwable == null) {
                    throwable = throwable20;
                } else if (throwable != throwable20) {
                    throwable.addSuppressed(throwable20);
                }
                throw throwable;
            }
        }
    }

    static class ModelParser
    implements SAXListener {
        private final DBVContainer rootContainer;
        private DBVContainer curContainer = null;
        private DBVEntity curEntity = null;
        private DBVEntityAttribute curAttribute = null;
        private DBVTransformSettings curTransformSettings = null;
        private DBVEntityConstraint curConstraint;
        private DBVColorOverride curColor;
        private boolean colorValue = false;

        public ModelParser(@NotNull DBVContainer rootContainer) {
            this.rootContainer = rootContainer;
        }

        public void saxStartElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName, @NotNull Attributes attributes) throws XMLException {
            switch (localName) {
                case "container": {
                    if (this.curContainer == null) {
                        this.curContainer = this.rootContainer;
                        break;
                    }
                    DBVContainer container = new DBVContainer(this.curContainer, attributes.getValue("name"));
                    this.curContainer.addContainer(container);
                    this.curContainer = container;
                    break;
                }
                case "entity": {
                    this.curEntity = new DBVEntity(this.curContainer, attributes.getValue("name"), attributes.getValue("description"));
                    this.curContainer.addEntity(this.curEntity);
                    break;
                }
                case "property": {
                    if (this.curTransformSettings != null) {
                        this.curTransformSettings.setTransformOption(attributes.getValue("name"), attributes.getValue("value"));
                        break;
                    }
                    if (this.curAttribute != null) {
                        this.curAttribute.setProperty(attributes.getValue("name"), attributes.getValue("value"));
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curEntity.setProperty(attributes.getValue("name"), attributes.getValue("value"));
                    break;
                }
                case "constraint": {
                    if (this.curEntity == null) break;
                    this.curConstraint = new DBVEntityConstraint(this.curEntity, DBSEntityConstraintType.VIRTUAL_KEY, attributes.getValue("name"));
                    this.curEntity.addConstraint(this.curConstraint, false);
                    break;
                }
                case "attribute": {
                    if (this.curConstraint != null) {
                        this.curConstraint.addAttribute(attributes.getValue("name"));
                        break;
                    }
                    if (this.curAttribute != null) {
                        DBVEntityAttribute childAttribute = new DBVEntityAttribute(this.curEntity, this.curAttribute, attributes.getValue("name"));
                        this.curAttribute.addChild(childAttribute);
                        this.curAttribute = childAttribute;
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curAttribute = new DBVEntityAttribute(this.curEntity, null, attributes.getValue("name"));
                    this.curEntity.addVirtualAttribute(this.curAttribute, false);
                    break;
                }
                case "transform": {
                    this.curTransformSettings = new DBVTransformSettings();
                    this.curTransformSettings.setCustomTransformer(attributes.getValue("custom"));
                    if (this.curAttribute != null) {
                        this.curAttribute.setTransformSettings(this.curTransformSettings);
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curEntity.setTransformSettings(this.curTransformSettings);
                    break;
                }
                case "exclude": 
                case "include": {
                    String transformerId = attributes.getValue("id");
                    if (this.curTransformSettings == null || CommonUtils.isEmpty((String)transformerId)) break;
                    DBDAttributeTransformerDescriptor transformer = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(transformerId);
                    if (transformer == null) {
                        log.warn("Transformer '" + transformerId + "' not found");
                        break;
                    }
                    this.curTransformSettings.enableTransformer(transformer, "include".equals(localName));
                    break;
                }
                case "color": {
                    if (this.curEntity == null) break;
                    try {
                        this.curColor = new DBVColorOverride(attributes.getValue("name"), DBCLogicalOperator.valueOf(attributes.getValue("operator")), null, attributes.getValue("foreground"), attributes.getValue("background"));
                        this.curColor.setRange(CommonUtils.getBoolean((String)attributes.getValue("range"), (boolean)false));
                        this.curColor.setSingleColumn(CommonUtils.getBoolean((String)attributes.getValue("singleColumn"), (boolean)false));
                        this.curColor.setColorForeground2(attributes.getValue("foreground2"));
                        this.curColor.setColorBackground2(attributes.getValue("background2"));
                        this.curEntity.addColorOverride(this.curColor);
                    }
                    catch (Throwable e) {
                        log.warn("Error reading color settings", e);
                    }
                    break;
                }
                case "value": {
                    if (this.curColor == null) break;
                    this.colorValue = true;
                }
            }
        }

        public void saxText(@NotNull SAXReader reader, @NotNull String data) {
            if (this.colorValue) {
                this.curColor.addAttributeValue(GeneralUtils.deserializeObject(data));
            }
        }

        public void saxEndElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName) {
            switch (localName) {
                case "container": {
                    this.curContainer = this.curContainer.getParentObject();
                    break;
                }
                case "entity": {
                    this.curEntity = null;
                    break;
                }
                case "constraint": {
                    this.curConstraint = null;
                    break;
                }
                case "attribute": {
                    if (this.curAttribute == null) break;
                    this.curAttribute = this.curAttribute.getParent();
                    break;
                }
                case "transform": {
                    this.curTransformSettings = null;
                }
                case "color": {
                    this.curColor = null;
                    break;
                }
                case "value": {
                    if (this.curColor == null) break;
                    this.colorValue = false;
                }
            }
        }
    }
}

