/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.model.Model;

public class DockingStatus {
    protected Model model;
    protected List<String> docked = new ArrayList<String>(10);
    protected List<String> slided = new ArrayList<String>(10);
    private boolean marked = false;

    DockingStatus(Model model) {
        this.model = model;
    }

    public void mark() {
        Set<ModeImpl> set = this.model.getModes();
        for (ModeImpl modeImpl : set) {
            if (modeImpl.getState() == 1) continue;
            List<String> list = this.model.getModeOpenedTopComponentsIDs(modeImpl);
            if (modeImpl.getKind() == 0) {
                this.docked.addAll(list);
                this.slided.removeAll(list);
                continue;
            }
            if (modeImpl.getKind() != 2) continue;
            this.docked.removeAll(list);
            this.slided.addAll(list);
        }
        this.marked = true;
    }

    public boolean shouldDock(String string) {
        return null != string && this.docked.contains(string) && this.marked;
    }

    public boolean shouldSlide(String string) {
        return null != string && (this.slided.contains(string) || !this.slided.contains(string) && !this.docked.contains(string));
    }

    public void addDocked(String string) {
        if (null != string) {
            this.docked.add(string);
            this.slided.remove(string);
        }
    }

    public void addSlided(String string) {
        if (null != string) {
            this.slided.add(string);
            this.docked.remove(string);
        }
    }

    public boolean isDocked(String string) {
        return null != string && this.docked.contains(string);
    }

    public boolean isSlided(String string) {
        return null != string && this.slided.contains(string);
    }

    void clear() {
        this.docked.clear();
        this.slided.clear();
    }
}

