/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UndefAction;
import com.dickimawbooks.texparserlib.generic.DefaultTeXParserListener;
import java.io.IOException;

public class TeXParserSetUndefAction
extends ControlSequence {
    private UndefAction action = UndefAction.UNKNOWN;

    public TeXParserSetUndefAction() {
        this(UndefAction.UNKNOWN);
    }

    public TeXParserSetUndefAction(UndefAction undefAction) {
        this("TeXParserSetUndefAction", undefAction);
    }

    public TeXParserSetUndefAction(String string, UndefAction undefAction) {
        super(string);
        this.action = undefAction;
    }

    @Deprecated
    public TeXParserSetUndefAction(int n) {
        this("TeXParserSetUndefAction", n);
    }

    @Deprecated
    public TeXParserSetUndefAction(String string, int n) {
        super(string);
        switch (n) {
            case 0: {
                this.action = UndefAction.ERROR;
                break;
            }
            case 1: {
                this.action = UndefAction.WARN;
                break;
            }
            case 2: {
                this.action = UndefAction.MESSAGE;
                break;
            }
            case 3: {
                this.action = UndefAction.IGNORE;
                break;
            }
            default: {
                this.action = UndefAction.UNKNOWN;
            }
        }
    }

    @Override
    public Object clone() {
        return new TeXParserSetUndefAction(this.getName(), this.action);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        UndefAction undefAction = this.action;
        if (this.action == UndefAction.UNKNOWN) {
            Numerical numerical = this.popNumericalArg(teXParser, teXObjectList);
            int n = numerical.number(teXParser);
            switch (n) {
                case 0: {
                    undefAction = UndefAction.ERROR;
                    break;
                }
                case 1: {
                    undefAction = UndefAction.WARN;
                    break;
                }
                case 2: {
                    undefAction = UndefAction.MESSAGE;
                    break;
                }
                case 3: {
                    undefAction = UndefAction.IGNORE;
                    break;
                }
                default: {
                    throw new TeXSyntaxException(teXParser, "tex.error.generic", "Invalid undef action: " + n);
                }
            }
        }
        ((DefaultTeXParserListener)teXParser.getListener()).setUndefinedAction(undefAction);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

