/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_LOADINT4REWRITEPASS
#define GEN_PASS_DECL_PREVENTMMAV3LOOPUNROLLINGPASS
#define GEN_PASS_DECL_SPARSEADDENCODINGPASS
#define GEN_PASS_DECL_SPARSEBLOCKEDTOMMAPASS
#define GEN_PASS_DECL_SPARSEDOTOPTOLLVMPASS
#define GEN_PASS_DECL_SPARSELOCALLOADTOLLVMPASS
#define GEN_PASS_DECL_SPARSEREMOVELAYOUTCONVERSIONPASS
#define GEN_PASS_DECL_SPARSEWGMMAOPTOLLVMPASS
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// LoadInt4RewritePass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_LOADINT4REWRITEPASS
#undef GEN_PASS_DECL_LOADINT4REWRITEPASS
#endif // GEN_PASS_DECL_LOADINT4REWRITEPASS
#ifdef GEN_PASS_DEF_LOADINT4REWRITEPASS
namespace impl {

template <typename DerivedT>
class LoadInt4RewritePassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = LoadInt4RewritePassBase;

  LoadInt4RewritePassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  LoadInt4RewritePassBase(const LoadInt4RewritePassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  LoadInt4RewritePassBase& operator=(const LoadInt4RewritePassBase &) = delete;
  LoadInt4RewritePassBase(LoadInt4RewritePassBase &&) = delete;
  LoadInt4RewritePassBase& operator=(LoadInt4RewritePassBase &&) = delete;
  ~LoadInt4RewritePassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("int4-to-packed-int4-rewrite");
  }
  ::llvm::StringRef getArgument() const override { return "int4-to-packed-int4-rewrite"; }

  ::llvm::StringRef getDescription() const override { return "Converts ops with int4 tensors to the ops with int4 packed to int8 tensors."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LoadInt4RewritePass");
  }
  ::llvm::StringRef getName() const override { return "LoadInt4RewritePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LoadInt4RewritePassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_LOADINT4REWRITEPASS
#endif // GEN_PASS_DEF_LOADINT4REWRITEPASS

//===----------------------------------------------------------------------===//
// PreventMmaV3LoopUnrollingPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_PREVENTMMAV3LOOPUNROLLINGPASS
#undef GEN_PASS_DECL_PREVENTMMAV3LOOPUNROLLINGPASS
#endif // GEN_PASS_DECL_PREVENTMMAV3LOOPUNROLLINGPASS
#ifdef GEN_PASS_DEF_PREVENTMMAV3LOOPUNROLLINGPASS
namespace impl {

template <typename DerivedT>
class PreventMmaV3LoopUnrollingPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = PreventMmaV3LoopUnrollingPassBase;

  PreventMmaV3LoopUnrollingPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  PreventMmaV3LoopUnrollingPassBase(const PreventMmaV3LoopUnrollingPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  PreventMmaV3LoopUnrollingPassBase& operator=(const PreventMmaV3LoopUnrollingPassBase &) = delete;
  PreventMmaV3LoopUnrollingPassBase(PreventMmaV3LoopUnrollingPassBase &&) = delete;
  PreventMmaV3LoopUnrollingPassBase& operator=(PreventMmaV3LoopUnrollingPassBase &&) = delete;
  ~PreventMmaV3LoopUnrollingPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("prevent-mmav3-loop-unrolling");
  }
  ::llvm::StringRef getArgument() const override { return "prevent-mmav3-loop-unrolling"; }

  ::llvm::StringRef getDescription() const override { return "Prevent MMAv3 loop unrolling."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PreventMmaV3LoopUnrollingPass");
  }
  ::llvm::StringRef getName() const override { return "PreventMmaV3LoopUnrollingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(PreventMmaV3LoopUnrollingPassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_PREVENTMMAV3LOOPUNROLLINGPASS
#endif // GEN_PASS_DEF_PREVENTMMAV3LOOPUNROLLINGPASS

//===----------------------------------------------------------------------===//
// SparseAddEncodingPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSEADDENCODINGPASS
struct SparseAddEncodingPassOptions {
  int32_t num_warps_ = 4;
  int32_t threads_per_warp_ = 32;
  int32_t num_ctas_ = 1;
};
#undef GEN_PASS_DECL_SPARSEADDENCODINGPASS
#endif // GEN_PASS_DECL_SPARSEADDENCODINGPASS
#ifdef GEN_PASS_DEF_SPARSEADDENCODINGPASS
namespace impl {

template <typename DerivedT>
class SparseAddEncodingPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseAddEncodingPassBase;

  SparseAddEncodingPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseAddEncodingPassBase(const SparseAddEncodingPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseAddEncodingPassBase& operator=(const SparseAddEncodingPassBase &) = delete;
  SparseAddEncodingPassBase(SparseAddEncodingPassBase &&) = delete;
  SparseAddEncodingPassBase& operator=(SparseAddEncodingPassBase &&) = delete;
  ~SparseAddEncodingPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-add-encoding");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-add-encoding"; }

  ::llvm::StringRef getDescription() const override { return "Add sparse encoding for all the arguments of a SparseDotOp."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseAddEncodingPass");
  }
  ::llvm::StringRef getName() const override { return "SparseAddEncodingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseAddEncodingPassBase<DerivedT>)

  SparseAddEncodingPassBase(SparseAddEncodingPassOptions options) : SparseAddEncodingPassBase() {
    num_warps_ = std::move(options.num_warps_);
    threads_per_warp_ = std::move(options.threads_per_warp_);
    num_ctas_ = std::move(options.num_ctas_);
  }
protected:
  ::mlir::Pass::Option<int32_t> num_warps_{*this, "num-warps", ::llvm::cl::desc("Number of warps"), ::llvm::cl::init(4)};
  ::mlir::Pass::Option<int32_t> threads_per_warp_{*this, "threads-per-warp", ::llvm::cl::desc("Number of threads per warp"), ::llvm::cl::init(32)};
  ::mlir::Pass::Option<int32_t> num_ctas_{*this, "num-ctas", ::llvm::cl::desc("Number of CTAs in a CGA"), ::llvm::cl::init(1)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSEADDENCODINGPASS
#endif // GEN_PASS_DEF_SPARSEADDENCODINGPASS

//===----------------------------------------------------------------------===//
// SparseBlockedToMMAPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSEBLOCKEDTOMMAPASS
#undef GEN_PASS_DECL_SPARSEBLOCKEDTOMMAPASS
#endif // GEN_PASS_DECL_SPARSEBLOCKEDTOMMAPASS
#ifdef GEN_PASS_DEF_SPARSEBLOCKEDTOMMAPASS
namespace impl {

template <typename DerivedT>
class SparseBlockedToMMAPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseBlockedToMMAPassBase;

  SparseBlockedToMMAPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseBlockedToMMAPassBase(const SparseBlockedToMMAPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseBlockedToMMAPassBase& operator=(const SparseBlockedToMMAPassBase &) = delete;
  SparseBlockedToMMAPassBase(SparseBlockedToMMAPassBase &&) = delete;
  SparseBlockedToMMAPassBase& operator=(SparseBlockedToMMAPassBase &&) = delete;
  ~SparseBlockedToMMAPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-blocked-to-mma");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-blocked-to-mma"; }

  ::llvm::StringRef getDescription() const override { return "Add convert layouts to/from MMA before and after SparseDotOp."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseBlockedToMMAPass");
  }
  ::llvm::StringRef getName() const override { return "SparseBlockedToMMAPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseBlockedToMMAPassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSEBLOCKEDTOMMAPASS
#endif // GEN_PASS_DEF_SPARSEBLOCKEDTOMMAPASS

//===----------------------------------------------------------------------===//
// SparseDotOpToLLVMPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSEDOTOPTOLLVMPASS
#undef GEN_PASS_DECL_SPARSEDOTOPTOLLVMPASS
#endif // GEN_PASS_DECL_SPARSEDOTOPTOLLVMPASS
#ifdef GEN_PASS_DEF_SPARSEDOTOPTOLLVMPASS
namespace impl {

template <typename DerivedT>
class SparseDotOpToLLVMPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseDotOpToLLVMPassBase;

  SparseDotOpToLLVMPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseDotOpToLLVMPassBase(const SparseDotOpToLLVMPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseDotOpToLLVMPassBase& operator=(const SparseDotOpToLLVMPassBase &) = delete;
  SparseDotOpToLLVMPassBase(SparseDotOpToLLVMPassBase &&) = delete;
  SparseDotOpToLLVMPassBase& operator=(SparseDotOpToLLVMPassBase &&) = delete;
  ~SparseDotOpToLLVMPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-dot-to-llvm");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-dot-to-llvm"; }

  ::llvm::StringRef getDescription() const override { return "Lowers sparse dot to LLVM"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseDotOpToLLVMPass");
  }
  ::llvm::StringRef getName() const override { return "SparseDotOpToLLVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvgpu::NVGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseDotOpToLLVMPassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSEDOTOPTOLLVMPASS
#endif // GEN_PASS_DEF_SPARSEDOTOPTOLLVMPASS

//===----------------------------------------------------------------------===//
// SparseLocalLoadToLLVMPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSELOCALLOADTOLLVMPASS
#undef GEN_PASS_DECL_SPARSELOCALLOADTOLLVMPASS
#endif // GEN_PASS_DECL_SPARSELOCALLOADTOLLVMPASS
#ifdef GEN_PASS_DEF_SPARSELOCALLOADTOLLVMPASS
namespace impl {

template <typename DerivedT>
class SparseLocalLoadToLLVMPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseLocalLoadToLLVMPassBase;

  SparseLocalLoadToLLVMPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseLocalLoadToLLVMPassBase(const SparseLocalLoadToLLVMPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseLocalLoadToLLVMPassBase& operator=(const SparseLocalLoadToLLVMPassBase &) = delete;
  SparseLocalLoadToLLVMPassBase(SparseLocalLoadToLLVMPassBase &&) = delete;
  SparseLocalLoadToLLVMPassBase& operator=(SparseLocalLoadToLLVMPassBase &&) = delete;
  ~SparseLocalLoadToLLVMPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-local-load-to-llvm");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-local-load-to-llvm"; }

  ::llvm::StringRef getDescription() const override { return "Lowers sparse local load to LLVM"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseLocalLoadToLLVMPass");
  }
  ::llvm::StringRef getName() const override { return "SparseLocalLoadToLLVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::LLVM::LLVMDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseLocalLoadToLLVMPassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSELOCALLOADTOLLVMPASS
#endif // GEN_PASS_DEF_SPARSELOCALLOADTOLLVMPASS

//===----------------------------------------------------------------------===//
// SparseRemoveLayoutConversionPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSEREMOVELAYOUTCONVERSIONPASS
#undef GEN_PASS_DECL_SPARSEREMOVELAYOUTCONVERSIONPASS
#endif // GEN_PASS_DECL_SPARSEREMOVELAYOUTCONVERSIONPASS
#ifdef GEN_PASS_DEF_SPARSEREMOVELAYOUTCONVERSIONPASS
namespace impl {

template <typename DerivedT>
class SparseRemoveLayoutConversionPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseRemoveLayoutConversionPassBase;

  SparseRemoveLayoutConversionPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseRemoveLayoutConversionPassBase(const SparseRemoveLayoutConversionPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseRemoveLayoutConversionPassBase& operator=(const SparseRemoveLayoutConversionPassBase &) = delete;
  SparseRemoveLayoutConversionPassBase(SparseRemoveLayoutConversionPassBase &&) = delete;
  SparseRemoveLayoutConversionPassBase& operator=(SparseRemoveLayoutConversionPassBase &&) = delete;
  ~SparseRemoveLayoutConversionPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-remove-layout-conversion");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-remove-layout-conversion"; }

  ::llvm::StringRef getDescription() const override { return "Replaces ConvertLayoutOp with sparse dot encoding"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseRemoveLayoutConversionPass");
  }
  ::llvm::StringRef getName() const override { return "SparseRemoveLayoutConversionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseRemoveLayoutConversionPassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSEREMOVELAYOUTCONVERSIONPASS
#endif // GEN_PASS_DEF_SPARSEREMOVELAYOUTCONVERSIONPASS

//===----------------------------------------------------------------------===//
// SparseWGMMAOpToLLVMPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSEWGMMAOPTOLLVMPASS
#undef GEN_PASS_DECL_SPARSEWGMMAOPTOLLVMPASS
#endif // GEN_PASS_DECL_SPARSEWGMMAOPTOLLVMPASS
#ifdef GEN_PASS_DEF_SPARSEWGMMAOPTOLLVMPASS
namespace impl {

template <typename DerivedT>
class SparseWGMMAOpToLLVMPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseWGMMAOpToLLVMPassBase;

  SparseWGMMAOpToLLVMPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseWGMMAOpToLLVMPassBase(const SparseWGMMAOpToLLVMPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseWGMMAOpToLLVMPassBase& operator=(const SparseWGMMAOpToLLVMPassBase &) = delete;
  SparseWGMMAOpToLLVMPassBase(SparseWGMMAOpToLLVMPassBase &&) = delete;
  SparseWGMMAOpToLLVMPassBase& operator=(SparseWGMMAOpToLLVMPassBase &&) = delete;
  ~SparseWGMMAOpToLLVMPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-wgmma-to-llvm");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-wgmma-to-llvm"; }

  ::llvm::StringRef getDescription() const override { return "Lowers sparse WGMMA to LLVM"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseWGMMAOpToLLVMPass");
  }
  ::llvm::StringRef getName() const override { return "SparseWGMMAOpToLLVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvgpu::NVGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseWGMMAOpToLLVMPassBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSEWGMMAOPTOLLVMPASS
#endif // GEN_PASS_DEF_SPARSEWGMMAOPTOLLVMPASS
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// LoadInt4RewritePass Registration
//===----------------------------------------------------------------------===//

inline void registerLoadInt4RewritePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateInt4ToPackedInt4RewritePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerLoadInt4RewritePassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateInt4ToPackedInt4RewritePass();
  });
}

//===----------------------------------------------------------------------===//
// PreventMmaV3LoopUnrollingPass Registration
//===----------------------------------------------------------------------===//

inline void registerPreventMmaV3LoopUnrollingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreatePreventMmaV3LoopUnrollingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerPreventMmaV3LoopUnrollingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreatePreventMmaV3LoopUnrollingPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseAddEncodingPass Registration
//===----------------------------------------------------------------------===//

inline void registerSparseAddEncodingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseAddEncodingPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseAddEncodingPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseAddEncodingPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseBlockedToMMAPass Registration
//===----------------------------------------------------------------------===//

inline void registerSparseBlockedToMMAPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseBlockedToMMAPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseBlockedToMMAPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseBlockedToMMAPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseDotOpToLLVMPass Registration
//===----------------------------------------------------------------------===//

inline void registerSparseDotOpToLLVMPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseDotOpToLLVMPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseDotOpToLLVMPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseDotOpToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseLocalLoadToLLVMPass Registration
//===----------------------------------------------------------------------===//

inline void registerSparseLocalLoadToLLVMPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseLocalLoadToLLVMPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseLocalLoadToLLVMPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseLocalLoadToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseRemoveLayoutConversionPass Registration
//===----------------------------------------------------------------------===//

inline void registerSparseRemoveLayoutConversionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseRemoveLayoutConversionPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseRemoveLayoutConversionPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseRemoveLayoutConversionPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseWGMMAOpToLLVMPass Registration
//===----------------------------------------------------------------------===//

inline void registerSparseWGMMAOpToLLVMPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseWGMMAOpToLLVMPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseWGMMAOpToLLVMPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return CreateSparseWGMMAOpToLLVMPass();
  });
}

//===----------------------------------------------------------------------===//
// TritonFusionTransforms Registration
//===----------------------------------------------------------------------===//

inline void registerTritonFusionTransformsPasses() {
  registerLoadInt4RewritePass();
  registerPreventMmaV3LoopUnrollingPass();
  registerSparseAddEncodingPass();
  registerSparseBlockedToMMAPass();
  registerSparseDotOpToLLVMPass();
  registerSparseLocalLoadToLLVMPass();
  registerSparseRemoveLayoutConversionPass();
  registerSparseWGMMAOpToLLVMPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class LoadInt4RewritePassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = LoadInt4RewritePassBase;

  LoadInt4RewritePassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  LoadInt4RewritePassBase(const LoadInt4RewritePassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  LoadInt4RewritePassBase& operator=(const LoadInt4RewritePassBase &) = delete;
  LoadInt4RewritePassBase(LoadInt4RewritePassBase &&) = delete;
  LoadInt4RewritePassBase& operator=(LoadInt4RewritePassBase &&) = delete;
  ~LoadInt4RewritePassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("int4-to-packed-int4-rewrite");
  }
  ::llvm::StringRef getArgument() const override { return "int4-to-packed-int4-rewrite"; }

  ::llvm::StringRef getDescription() const override { return "Converts ops with int4 tensors to the ops with int4 packed to int8 tensors."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LoadInt4RewritePass");
  }
  ::llvm::StringRef getName() const override { return "LoadInt4RewritePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LoadInt4RewritePassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class PreventMmaV3LoopUnrollingPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = PreventMmaV3LoopUnrollingPassBase;

  PreventMmaV3LoopUnrollingPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  PreventMmaV3LoopUnrollingPassBase(const PreventMmaV3LoopUnrollingPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  PreventMmaV3LoopUnrollingPassBase& operator=(const PreventMmaV3LoopUnrollingPassBase &) = delete;
  PreventMmaV3LoopUnrollingPassBase(PreventMmaV3LoopUnrollingPassBase &&) = delete;
  PreventMmaV3LoopUnrollingPassBase& operator=(PreventMmaV3LoopUnrollingPassBase &&) = delete;
  ~PreventMmaV3LoopUnrollingPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("prevent-mmav3-loop-unrolling");
  }
  ::llvm::StringRef getArgument() const override { return "prevent-mmav3-loop-unrolling"; }

  ::llvm::StringRef getDescription() const override { return "Prevent MMAv3 loop unrolling."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PreventMmaV3LoopUnrollingPass");
  }
  ::llvm::StringRef getName() const override { return "PreventMmaV3LoopUnrollingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(PreventMmaV3LoopUnrollingPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class SparseAddEncodingPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseAddEncodingPassBase;

  SparseAddEncodingPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseAddEncodingPassBase(const SparseAddEncodingPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseAddEncodingPassBase& operator=(const SparseAddEncodingPassBase &) = delete;
  SparseAddEncodingPassBase(SparseAddEncodingPassBase &&) = delete;
  SparseAddEncodingPassBase& operator=(SparseAddEncodingPassBase &&) = delete;
  ~SparseAddEncodingPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-add-encoding");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-add-encoding"; }

  ::llvm::StringRef getDescription() const override { return "Add sparse encoding for all the arguments of a SparseDotOp."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseAddEncodingPass");
  }
  ::llvm::StringRef getName() const override { return "SparseAddEncodingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseAddEncodingPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<int32_t> num_warps_{*this, "num-warps", ::llvm::cl::desc("Number of warps"), ::llvm::cl::init(4)};
  ::mlir::Pass::Option<int32_t> threads_per_warp_{*this, "threads-per-warp", ::llvm::cl::desc("Number of threads per warp"), ::llvm::cl::init(32)};
  ::mlir::Pass::Option<int32_t> num_ctas_{*this, "num-ctas", ::llvm::cl::desc("Number of CTAs in a CGA"), ::llvm::cl::init(1)};
};

template <typename DerivedT>
class SparseBlockedToMMAPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseBlockedToMMAPassBase;

  SparseBlockedToMMAPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseBlockedToMMAPassBase(const SparseBlockedToMMAPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseBlockedToMMAPassBase& operator=(const SparseBlockedToMMAPassBase &) = delete;
  SparseBlockedToMMAPassBase(SparseBlockedToMMAPassBase &&) = delete;
  SparseBlockedToMMAPassBase& operator=(SparseBlockedToMMAPassBase &&) = delete;
  ~SparseBlockedToMMAPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-blocked-to-mma");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-blocked-to-mma"; }

  ::llvm::StringRef getDescription() const override { return "Add convert layouts to/from MMA before and after SparseDotOp."; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseBlockedToMMAPass");
  }
  ::llvm::StringRef getName() const override { return "SparseBlockedToMMAPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseBlockedToMMAPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class SparseDotOpToLLVMPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseDotOpToLLVMPassBase;

  SparseDotOpToLLVMPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseDotOpToLLVMPassBase(const SparseDotOpToLLVMPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseDotOpToLLVMPassBase& operator=(const SparseDotOpToLLVMPassBase &) = delete;
  SparseDotOpToLLVMPassBase(SparseDotOpToLLVMPassBase &&) = delete;
  SparseDotOpToLLVMPassBase& operator=(SparseDotOpToLLVMPassBase &&) = delete;
  ~SparseDotOpToLLVMPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-dot-to-llvm");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-dot-to-llvm"; }

  ::llvm::StringRef getDescription() const override { return "Lowers sparse dot to LLVM"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseDotOpToLLVMPass");
  }
  ::llvm::StringRef getName() const override { return "SparseDotOpToLLVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvgpu::NVGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseDotOpToLLVMPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class SparseLocalLoadToLLVMPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseLocalLoadToLLVMPassBase;

  SparseLocalLoadToLLVMPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseLocalLoadToLLVMPassBase(const SparseLocalLoadToLLVMPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseLocalLoadToLLVMPassBase& operator=(const SparseLocalLoadToLLVMPassBase &) = delete;
  SparseLocalLoadToLLVMPassBase(SparseLocalLoadToLLVMPassBase &&) = delete;
  SparseLocalLoadToLLVMPassBase& operator=(SparseLocalLoadToLLVMPassBase &&) = delete;
  ~SparseLocalLoadToLLVMPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-local-load-to-llvm");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-local-load-to-llvm"; }

  ::llvm::StringRef getDescription() const override { return "Lowers sparse local load to LLVM"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseLocalLoadToLLVMPass");
  }
  ::llvm::StringRef getName() const override { return "SparseLocalLoadToLLVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::LLVM::LLVMDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseLocalLoadToLLVMPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class SparseRemoveLayoutConversionPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseRemoveLayoutConversionPassBase;

  SparseRemoveLayoutConversionPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseRemoveLayoutConversionPassBase(const SparseRemoveLayoutConversionPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseRemoveLayoutConversionPassBase& operator=(const SparseRemoveLayoutConversionPassBase &) = delete;
  SparseRemoveLayoutConversionPassBase(SparseRemoveLayoutConversionPassBase &&) = delete;
  SparseRemoveLayoutConversionPassBase& operator=(SparseRemoveLayoutConversionPassBase &&) = delete;
  ~SparseRemoveLayoutConversionPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-remove-layout-conversion");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-remove-layout-conversion"; }

  ::llvm::StringRef getDescription() const override { return "Replaces ConvertLayoutOp with sparse dot encoding"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseRemoveLayoutConversionPass");
  }
  ::llvm::StringRef getName() const override { return "SparseRemoveLayoutConversionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseRemoveLayoutConversionPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class SparseWGMMAOpToLLVMPassBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = SparseWGMMAOpToLLVMPassBase;

  SparseWGMMAOpToLLVMPassBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseWGMMAOpToLLVMPassBase(const SparseWGMMAOpToLLVMPassBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  SparseWGMMAOpToLLVMPassBase& operator=(const SparseWGMMAOpToLLVMPassBase &) = delete;
  SparseWGMMAOpToLLVMPassBase(SparseWGMMAOpToLLVMPassBase &&) = delete;
  SparseWGMMAOpToLLVMPassBase& operator=(SparseWGMMAOpToLLVMPassBase &&) = delete;
  ~SparseWGMMAOpToLLVMPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-wgmma-to-llvm");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-wgmma-to-llvm"; }

  ::llvm::StringRef getDescription() const override { return "Lowers sparse WGMMA to LLVM"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseWGMMAOpToLLVMPass");
  }
  ::llvm::StringRef getName() const override { return "SparseWGMMAOpToLLVMPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<triton::gpu::TritonGPUDialect>();
    registry.insert<mlir::triton::nvgpu::NVGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseWGMMAOpToLLVMPassBase<DerivedT>)

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
