/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_CONVERTTRITONTOTRITONGPU
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// ConvertTritonToTritonGPU
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_CONVERTTRITONTOTRITONGPU
struct ConvertTritonToTritonGPUOptions {
  int32_t numWarps = 4;
  int32_t threadsPerWarp = 32;
  int32_t numCTAs = 1;
  std::string target = "";
};
#undef GEN_PASS_DECL_CONVERTTRITONTOTRITONGPU
#endif // GEN_PASS_DECL_CONVERTTRITONTOTRITONGPU
#ifdef GEN_PASS_DEF_CONVERTTRITONTOTRITONGPU
namespace impl {

template <typename DerivedT>
class ConvertTritonToTritonGPUBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = ConvertTritonToTritonGPUBase;

  ConvertTritonToTritonGPUBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertTritonToTritonGPUBase(const ConvertTritonToTritonGPUBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  ConvertTritonToTritonGPUBase& operator=(const ConvertTritonToTritonGPUBase &) = delete;
  ConvertTritonToTritonGPUBase(ConvertTritonToTritonGPUBase &&) = delete;
  ConvertTritonToTritonGPUBase& operator=(ConvertTritonToTritonGPUBase &&) = delete;
  ~ConvertTritonToTritonGPUBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("convert-triton-to-tritongpu");
  }
  ::llvm::StringRef getArgument() const override { return "convert-triton-to-tritongpu"; }

  ::llvm::StringRef getDescription() const override { return "Convert Triton to TritonGPU"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ConvertTritonToTritonGPU");
  }
  ::llvm::StringRef getName() const override { return "ConvertTritonToTritonGPU"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::math::MathDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::triton::TritonDialect>();
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ConvertTritonToTritonGPUBase<DerivedT>)

  ConvertTritonToTritonGPUBase(ConvertTritonToTritonGPUOptions options) : ConvertTritonToTritonGPUBase() {
    numWarps = std::move(options.numWarps);
    threadsPerWarp = std::move(options.threadsPerWarp);
    numCTAs = std::move(options.numCTAs);
    target = std::move(options.target);
  }
protected:
  ::mlir::Pass::Option<int32_t> numWarps{*this, "num-warps", ::llvm::cl::desc("number of warps"), ::llvm::cl::init(4)};
  ::mlir::Pass::Option<int32_t> threadsPerWarp{*this, "threads-per-warp", ::llvm::cl::desc("number of threads per warp"), ::llvm::cl::init(32)};
  ::mlir::Pass::Option<int32_t> numCTAs{*this, "num-ctas", ::llvm::cl::desc("number of ctas in a cga"), ::llvm::cl::init(1)};
  ::mlir::Pass::Option<std::string> target{*this, "target", ::llvm::cl::desc("the GPU target, e.g., cuda:80, hip:gfx942"), ::llvm::cl::init("")};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_CONVERTTRITONTOTRITONGPU
#endif // GEN_PASS_DEF_CONVERTTRITONTOTRITONGPU
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// ConvertTritonToTritonGPU Registration
//===----------------------------------------------------------------------===//

inline void registerConvertTritonToTritonGPU() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::triton::createConvertTritonToTritonGPUPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerConvertTritonToTritonGPUPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::triton::createConvertTritonToTritonGPUPass();
  });
}

//===----------------------------------------------------------------------===//
// TritonToTritonGPU Registration
//===----------------------------------------------------------------------===//

inline void registerTritonToTritonGPUPasses() {
  registerConvertTritonToTritonGPU();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class ConvertTritonToTritonGPUBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = ConvertTritonToTritonGPUBase;

  ConvertTritonToTritonGPUBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ConvertTritonToTritonGPUBase(const ConvertTritonToTritonGPUBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  ConvertTritonToTritonGPUBase& operator=(const ConvertTritonToTritonGPUBase &) = delete;
  ConvertTritonToTritonGPUBase(ConvertTritonToTritonGPUBase &&) = delete;
  ConvertTritonToTritonGPUBase& operator=(ConvertTritonToTritonGPUBase &&) = delete;
  ~ConvertTritonToTritonGPUBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("convert-triton-to-tritongpu");
  }
  ::llvm::StringRef getArgument() const override { return "convert-triton-to-tritongpu"; }

  ::llvm::StringRef getDescription() const override { return "Convert Triton to TritonGPU"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ConvertTritonToTritonGPU");
  }
  ::llvm::StringRef getName() const override { return "ConvertTritonToTritonGPU"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::arith::ArithDialect>();
    registry.insert<mlir::math::MathDialect>();
    registry.insert<mlir::scf::SCFDialect>();
    registry.insert<mlir::triton::TritonDialect>();
    registry.insert<mlir::triton::gpu::TritonGPUDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ConvertTritonToTritonGPUBase<DerivedT>)

protected:
  ::mlir::Pass::Option<int32_t> numWarps{*this, "num-warps", ::llvm::cl::desc("number of warps"), ::llvm::cl::init(4)};
  ::mlir::Pass::Option<int32_t> threadsPerWarp{*this, "threads-per-warp", ::llvm::cl::desc("number of threads per warp"), ::llvm::cl::init(32)};
  ::mlir::Pass::Option<int32_t> numCTAs{*this, "num-ctas", ::llvm::cl::desc("number of ctas in a cga"), ::llvm::cl::init(1)};
  ::mlir::Pass::Option<std::string> target{*this, "target", ::llvm::cl::desc("the GPU target, e.g., cuda:80, hip:gfx942"), ::llvm::cl::init("")};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
