/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltinRegistry;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class PyDateTimeCAPIWrapper {
    static final TruffleString T_DATETIME_CAPI = PythonUtils.tsLiteral("datetime_CAPI");
    static final byte[] T_PYDATETIME_CAPSULE_NAME = PyCapsule.capsuleName("datetime.datetime_CAPI");
    private static final TruffleString T_TIMEDELTA = PythonUtils.tsLiteral("timedelta");
    public static final TruffleString T_TZINFO = PythonUtils.tsLiteral("tzinfo");
    public static final TruffleString T_DAY = PythonUtils.tsLiteral("day");
    public static final TruffleString T_MONTH = PythonUtils.tsLiteral("month");
    public static final TruffleString T_YEAR = PythonUtils.tsLiteral("year");
    public static final TruffleString T_HOUR = PythonUtils.tsLiteral("hour");
    public static final TruffleString T_MINUTE = PythonUtils.tsLiteral("minute");
    public static final TruffleString T_SECOND = PythonUtils.tsLiteral("second");
    public static final TruffleString T_MICROSECOND = PythonUtils.tsLiteral("microsecond");
    public static final TruffleString T_DAYS = PythonUtils.tsLiteral("days");
    public static final TruffleString T_SECONDS = PythonUtils.tsLiteral("seconds");
    public static final TruffleString T_MICROSECONDS = PythonUtils.tsLiteral("microseconds");
    private static final TruffleString T_TIMEZONE = PythonUtils.tsLiteral("timezone");
    private static final TruffleString T_UTC = PythonUtils.tsLiteral("utc");
    public static final TruffleString T_FROMTIMESTAMP = PythonUtils.tsLiteral("fromtimestamp");
    public static final TruffleString T_FOLD = PythonUtils.tsLiteral("fold");

    private PyDateTimeCAPIWrapper() {
    }

    public static PyCapsule initWrapper(PythonContext context, CApiContext capiContext) {
        CompilerAsserts.neverPartOfCompilation();
        CExtNodes.PCallCapiFunction callCapiFunction = CExtNodes.PCallCapiFunction.getUncached();
        callCapiFunction.call(NativeCAPISymbol.FUN_INIT_NATIVE_DATETIME, new Object[0]);
        PythonModule datetimeModule = AbstractImportNode.importModule(StringLiterals.T_DATETIME);
        capiContext.timezoneType = PyObjectGetAttr.executeUncached(datetimeModule, T_TIMEZONE);
        Object pointerObject = PyDateTimeCAPIWrapper.allocatePyDatetimeCAPI(datetimeModule);
        PyCapsule capsule = PFactory.createCapsuleJavaName(context.getLanguage(), pointerObject, T_PYDATETIME_CAPSULE_NAME);
        PyObjectSetAttr.executeUncached(datetimeModule, T_DATETIME_CAPI, capsule);
        assert (PyObjectGetAttr.executeUncached(datetimeModule, T_DATETIME_CAPI) != context.getNativeNull());
        return capsule;
    }

    public static void destroyWrapper(PyCapsule capsule) {
        CompilerAsserts.neverPartOfCompilation();
        CStructAccess.FreeNode.executeUncached(capsule.getPointer());
    }

    private static Object allocatePyDatetimeCAPI(Object datetimeModule) {
        CStructAccess.AllocateNode allocNode = CStructAccessFactory.AllocateNodeGen.getUncached();
        CStructAccess.WritePointerNode writePointerNode = CStructAccessFactory.WritePointerNodeGen.getUncached();
        PyObjectGetAttr getAttr = PyObjectGetAttr.getUncached();
        CApiTransitions.PythonToNativeNewRefNode toNativeNode = CApiTransitionsFactory.PythonToNativeNewRefNodeGen.getUncached();
        PythonManagedClass date = (PythonManagedClass)getAttr.execute(null, datetimeModule, StringLiterals.T_DATE);
        TypeNodes.SetBasicSizeNode.executeUncached(date, CStructs.PyDateTime_Date.size());
        Object dateType = toNativeNode.execute(date);
        PythonManagedClass dt = (PythonManagedClass)getAttr.execute(null, datetimeModule, StringLiterals.T_DATETIME);
        TypeNodes.SetBasicSizeNode.executeUncached(dt, CStructs.PyDateTime_DateTime.size());
        Object datetimeType = toNativeNode.execute(dt);
        PythonManagedClass time = (PythonManagedClass)getAttr.execute(null, datetimeModule, StringLiterals.T_TIME);
        TypeNodes.SetBasicSizeNode.executeUncached(time, CStructs.PyDateTime_Time.size());
        Object timeType = toNativeNode.execute(time);
        PythonManagedClass delta = (PythonManagedClass)getAttr.execute(null, datetimeModule, T_TIMEDELTA);
        TypeNodes.SetBasicSizeNode.executeUncached(delta, CStructs.PyDateTime_Delta.size());
        Object deltaType = toNativeNode.execute(delta);
        Object tzInfoType = toNativeNode.execute(getAttr.execute(null, datetimeModule, T_TZINFO));
        Object timezoneType = getAttr.execute(null, datetimeModule, T_TIMEZONE);
        Object timezoneUTC = toNativeNode.execute(getAttr.execute(null, timezoneType, T_UTC));
        Object mem = allocNode.alloc(CStructs.PyDateTime_CAPI);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__DateType, dateType);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__DateTimeType, datetimeType);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__TimeType, timeType);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__DeltaType, deltaType);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__TZInfoType, tzInfoType);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__TimeZone_UTC, timezoneUTC);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__Date_FromDate, PythonCextBuiltinRegistry.GraalPyPrivate_DateTimeCAPI_Date_FromDate);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__DateTime_FromDateAndTime, PythonCextBuiltinRegistry.GraalPyPrivate_DateTimeCAPI_DateTime_FromDateAndTime);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__Time_FromTime, PythonCextBuiltinRegistry.GraalPyPrivate_DateTimeCAPI_Time_FromTime);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__Delta_FromDelta, PythonCextBuiltinRegistry.GraalPyPrivate_DateTimeCAPI_Delta_FromDelta);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__TimeZone_FromTimeZone, PythonCextBuiltinRegistry.GraalPyPrivate_DateTimeCAPI_TimeZone_FromTimeZone);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__DateTime_FromTimestamp, PythonCextBuiltinRegistry.GraalPyPrivate_DateTimeCAPI_DateTime_FromTimestamp);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__Date_FromTimestamp, PythonCextBuiltinRegistry.GraalPyPrivate_DateTimeCAPI_Date_FromTimestamp);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__DateTime_FromDateAndTimeAndFold, PythonCextBuiltinRegistry.GraalPyPrivate_DateTimeCAPI_DateTime_FromDateAndTimeAndFold);
        writePointerNode.write(mem, CFields.PyDateTime_CAPI__Time_FromTimeAndFold, PythonCextBuiltinRegistry.GraalPyPrivate_DateTimeCAPI_Time_FromTimeAndFold);
        return mem;
    }
}

