/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import schemacrawler.schema.Column;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraintColumn;

final class TableCandidateKeys
implements Iterable<Column> {
    private final Table table;
    private final Set<Column> tableKeys;

    TableCandidateKeys(Table table) {
        this.table = Objects.requireNonNull(table, "No table provided");
        this.tableKeys = new HashSet<Column>();
        this.listTableKeys(table);
    }

    @Override
    public Iterator<Column> iterator() {
        return this.tableKeys.iterator();
    }

    public String toString() {
        return "%s: %s".formatted(this.table, this.tableKeys);
    }

    private void addColumnFromIndex(Table table, Index index) {
        IndexColumn indexColumn = (IndexColumn)index.getColumns().get(0);
        table.lookupColumn(indexColumn.getName()).ifPresent(column -> this.tableKeys.add((Column)column));
    }

    private void addColumnFromPrimaryKey(Table table, PrimaryKey primaryKey) {
        TableConstraintColumn tableConstraintColumn = (TableConstraintColumn)primaryKey.getConstrainedColumns().get(0);
        table.lookupColumn(tableConstraintColumn.getName()).ifPresent(column -> this.tableKeys.add((Column)column));
    }

    private void listTableKeys(Table table) {
        PrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey != null && primaryKey.getConstrainedColumns().size() == 1) {
            this.addColumnFromPrimaryKey(table, primaryKey);
        }
        for (Index index : table.getIndexes()) {
            if (index == null || !index.isUnique() || index.getColumns().size() != 1) continue;
            this.addColumnFromIndex(table, index);
        }
    }
}

