/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferencedSecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferencedSecurityGroup> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(ReferencedSecurityGroup.getter(ReferencedSecurityGroup::groupId)).setter(ReferencedSecurityGroup.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<String> PEERING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeeringStatus").getter(ReferencedSecurityGroup.getter(ReferencedSecurityGroup::peeringStatus)).setter(ReferencedSecurityGroup.setter(Builder::peeringStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringStatus").unmarshallLocationName("peeringStatus").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(ReferencedSecurityGroup.getter(ReferencedSecurityGroup::userId)).setter(ReferencedSecurityGroup.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").unmarshallLocationName("userId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(ReferencedSecurityGroup.getter(ReferencedSecurityGroup::vpcId)).setter(ReferencedSecurityGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcPeeringConnectionId").getter(ReferencedSecurityGroup.getter(ReferencedSecurityGroup::vpcPeeringConnectionId)).setter(ReferencedSecurityGroup.setter(Builder::vpcPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").unmarshallLocationName("vpcPeeringConnectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, PEERING_STATUS_FIELD, USER_ID_FIELD, VPC_ID_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReferencedSecurityGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final String peeringStatus;
    private final String userId;
    private final String vpcId;
    private final String vpcPeeringConnectionId;

    private ReferencedSecurityGroup(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.peeringStatus = builder.peeringStatus;
        this.userId = builder.userId;
        this.vpcId = builder.vpcId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String peeringStatus() {
        return this.peeringStatus;
    }

    public final String userId() {
        return this.userId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peeringStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferencedSecurityGroup)) {
            return false;
        }
        ReferencedSecurityGroup other = (ReferencedSecurityGroup)obj;
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.peeringStatus(), other.peeringStatus()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public final String toString() {
        return ToString.builder((String)"ReferencedSecurityGroup").add("GroupId", (Object)this.groupId()).add("PeeringStatus", (Object)this.peeringStatus()).add("UserId", (Object)this.userId()).add("VpcId", (Object)this.vpcId()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "PeeringStatus": {
                return Optional.ofNullable(clazz.cast(this.peeringStatus()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("PeeringStatus", PEERING_STATUS_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcPeeringConnectionId", VPC_PEERING_CONNECTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferencedSecurityGroup, T> g) {
        return obj -> g.apply((ReferencedSecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private String peeringStatus;
        private String userId;
        private String vpcId;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferencedSecurityGroup model) {
            this.groupId(model.groupId);
            this.peeringStatus(model.peeringStatus);
            this.userId(model.userId);
            this.vpcId(model.vpcId);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getPeeringStatus() {
            return this.peeringStatus;
        }

        public final void setPeeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
        }

        @Override
        public final Builder peeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public ReferencedSecurityGroup build() {
            return new ReferencedSecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferencedSecurityGroup> {
        public Builder groupId(String var1);

        public Builder peeringStatus(String var1);

        public Builder userId(String var1);

        public Builder vpcId(String var1);

        public Builder vpcPeeringConnectionId(String var1);
    }
}

