/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

public abstract class GeocacheCode {
    public static boolean isValidCode(String string) {
        if (string == null || !GeocacheCode.isLengthValid(string.length())) {
            return false;
        }
        Provider provider = Provider.getProvider(string);
        return provider != null && GeocacheCode.verifyCharactersAreValid(string);
    }

    private static boolean isLengthValid(int n) {
        return n > 4 && n <= 8;
    }

    private static boolean verifyCharactersAreValid(String string) {
        int n = 0;
        while (n < string.length()) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(string.charAt(n)) < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String getUrl(String string) {
        Provider provider = Provider.getProvider(string);
        if (provider != null && string != null && GeocacheCode.isLengthValid(string.length()) && GeocacheCode.verifyCharactersAreValid(string)) {
            return String.valueOf(provider._url) + string;
        }
        return null;
    }

    private static enum Provider {
        GEOCACHING_COM("GC", "https://coord.info/"),
        OPENCACHING_DE("OC", "https://www.opencaching.de/");

        private final String _prefix;
        private final String _url;

        private Provider(String string2, String string3) {
            this._prefix = string2;
            this._url = string3;
        }

        static Provider getProvider(String string) {
            if (string == null || string.length() < 2) {
                return null;
            }
            Provider[] providerArray = Provider.values();
            int n = providerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Provider provider = providerArray[n2];
                if (provider._prefix.charAt(0) == string.charAt(0) && provider._prefix.charAt(1) == string.charAt(1)) {
                    return provider;
                }
                ++n2;
            }
            return null;
        }
    }
}

