/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.CSSKeyframeRule;
import io.sf.carte.doc.style.css.CSSKeyframesRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.KeyframeRule;
import io.sf.carte.doc.style.css.om.PropertyCSSHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.CommentRemover;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class KeyframesRule
extends BaseCSSRule
implements CSSKeyframesRule {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private final CSSRuleArrayList cssRules;

    protected KeyframesRule(AbstractCSSStyleSheet parentSheet, byte origin) {
        super(parentSheet, (short)7, origin);
        this.cssRules = new CSSRuleArrayList();
    }

    KeyframesRule(AbstractCSSStyleSheet parentSheet, KeyframesRule copyfrom) {
        super(parentSheet, (short)7, copyfrom.getOrigin());
        this.name = copyfrom.name;
        this.cssRules = copyfrom.cssRules;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String keyframesName) {
        this.name = keyframesName;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public void appendRule(String rule) throws DOMException {
        KeyframeRule krule = new KeyframeRule(this);
        krule.setCssText(rule);
        this.cssRules.add(krule);
    }

    @Override
    public void deleteRule(String select) {
        try {
            select = this.keyframeSelector(select);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        for (int i = this.cssRules.getLength() - 1; i >= 0; --i) {
            CSSKeyframeRule rule = (CSSKeyframeRule)this.cssRules.get(i);
            if (!rule.getKeyText().equals(select)) continue;
            this.cssRules.remove(i);
            break;
        }
    }

    @Override
    public CSSKeyframeRule findRule(String select) throws DOMException {
        try {
            select = this.keyframeSelector(select);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        for (int i = this.cssRules.getLength() - 1; i >= 0; --i) {
            CSSKeyframeRule rule = (CSSKeyframeRule)this.cssRules.get(i);
            if (!rule.getKeyText().equals(select)) continue;
            return rule;
        }
        return null;
    }

    String keyframeSelector(String rawselector) {
        LexicalUnit selunit;
        StringReader re = new StringReader(rawselector);
        Parser parser = this.createSACParser();
        try {
            selunit = parser.parsePropertyValue(re);
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return KeyframesRule.keyframeSelector(selunit);
    }

    static String keyframeSelector(LexicalUnit selunit) {
        StringBuilder buffer = new StringBuilder();
        KeyframesRule.appendSelector(buffer, selunit);
        LexicalUnit lu = selunit.getNextLexicalUnit();
        while (lu != null) {
            LexicalUnit nextlu = lu.getNextLexicalUnit();
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA || nextlu == null) {
                throw new DOMException(12, "Wrong keyframe selector syntax: " + selunit.toString());
            }
            buffer.append(',');
            KeyframesRule.appendSelector(buffer, nextlu);
            lu = nextlu.getNextLexicalUnit();
        }
        return buffer.toString();
    }

    private static void appendSelector(StringBuilder buffer, LexicalUnit selunit) {
        LexicalUnit.LexicalType type = selunit.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.STRING) {
            buffer.append(selunit.getStringValue());
        } else if (type == LexicalUnit.LexicalType.PERCENTAGE) {
            float floatValue = selunit.getFloatValue();
            if (floatValue % 1.0f != 0.0f) {
                buffer.append(String.format(Locale.ROOT, "%s", Float.valueOf(floatValue)));
            } else {
                buffer.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(floatValue)));
            }
            buffer.append('%');
        } else if (type == LexicalUnit.LexicalType.INTEGER && selunit.getIntegerValue() == 0) {
            buffer.append('0');
        } else {
            throw new DOMException(12, "Wrong keyframe selector: " + selunit.toString());
        }
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(30 + this.getCssRules().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.name != null || !this.getCssRules().isEmpty()) {
            StringBuilder sb = new StringBuilder(30 + this.getCssRules().getLength() * 20);
            sb.append("@keyframes");
            if (this.name != null) {
                String sname = this.getName();
                if (sname.indexOf(32) == -1) {
                    sb.append(' ').append(sname);
                } else {
                    sb.append(' ').append('\'').append(sname).append('\'');
                }
            }
            sb.append('{');
            Iterator it = this.getCssRules().iterator();
            while (it.hasNext()) {
                sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
            }
            sb.append('}');
            return sb.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.name != null || !this.getCssRules().isEmpty()) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)"@keyframes ");
            if (this.name != null) {
                String sname = this.getName();
                if (sname.indexOf(32) == -1) {
                    wri.write((CharSequence)sname);
                } else {
                    wri.write('\'');
                    wri.write((CharSequence)sname);
                    wri.write('\'');
                }
            }
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            this.getCssRules().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endRuleList(wri);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, this.getTrailingComments());
        }
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        cssText = cssText.trim();
        int len = cssText.length();
        int atIdx = cssText.indexOf(64);
        if (len < 14 || atIdx == -1) {
            throw new DOMException(12, "Invalid @keyframes rule: " + cssText);
        }
        String ncText = CommentRemover.removeComments(cssText).toString().trim();
        CharSequence atkeyword = ncText.subSequence(0, 11);
        if (!ParseHelper.startsWithIgnoreCase(atkeyword, "@keyframes") || !Character.isWhitespace(atkeyword.charAt(10))) {
            throw new DOMException(13, "Not a @keyframes rule: " + cssText);
        }
        String body = cssText.substring(atIdx + 11);
        MyKeyframesHandler handler = new MyKeyframesHandler();
        CSSParser parser = (CSSParser)this.createSACParser();
        parser.setDocumentHandler(handler);
        try {
            parser.parseKeyFramesBody(body);
        }
        catch (CSSParseException e) {
            throw new DOMException(5, e.getMessage());
        }
    }

    @Override
    void clear() {
        this.cssRules.clear();
        this.resetComments();
    }

    @Override
    void setRule(AbstractCSSRule copyMe) {
        this.setPrecedingComments(copyMe.getPrecedingComments());
        this.setTrailingComments(copyMe.getTrailingComments());
        KeyframesRule other = (KeyframesRule)copyMe;
        this.name = other.name;
        this.cssRules.clear();
        this.cssRules.addAll(other.getCssRules());
        for (AbstractCSSRule rule : this.cssRules) {
            rule.setParentRule(this);
        }
    }

    @Override
    boolean hasErrorsOrWarnings() {
        for (AbstractCSSRule rule : this.cssRules) {
            if (!rule.hasErrorsOrWarnings()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cssRules.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyframesRule other = (KeyframesRule)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.cssRules == null ? other.cssRules != null : !this.cssRules.equals(other.cssRules));
    }

    @Override
    public KeyframesRule clone(AbstractCSSStyleSheet parentSheet) {
        return new KeyframesRule(parentSheet, this);
    }

    private class MyKeyframesHandler
    extends PropertyCSSHandler {
        private String name = null;
        private final CSSRuleArrayList cssRules = new CSSRuleArrayList();
        private KeyframeRule currentRule = null;
        private KeyframeRule lastRule = null;
        private StringList comments = null;

        private MyKeyframesHandler() {
        }

        @Override
        public void startKeyframes(String name) {
            this.name = name;
            this.newRule();
        }

        private void newRule() {
            this.lastRule = null;
        }

        @Override
        public void endKeyframes() {
            KeyframesRule.this.name = this.name;
            KeyframesRule.this.cssRules.clear();
            KeyframesRule.this.cssRules.addAll(this.cssRules);
            KeyframesRule.this.resetComments();
        }

        @Override
        public void startKeyframe(LexicalUnit keyframeSelector) {
            this.newRule();
            this.currentRule = new KeyframeRule(KeyframesRule.this);
            this.currentRule.setKeyText(KeyframesRule.keyframeSelector(keyframeSelector));
            this.setLexicalPropertyListener(this.currentRule.getLexicalPropertyListener());
            this.cssRules.add(this.currentRule);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            if (this.currentRule == null) throw new CSSException("Declaration outside of keyframe rule");
            if (important) {
                CSSPropertyValueException ex = new CSSPropertyValueException("Important declarations in a keyframe rule are not valid");
                ex.setValueText(value.toString() + " !important");
                this.currentRule.getStyleDeclarationErrorHandler().wrongValue(name, ex);
                return;
            } else {
                try {
                    super.property(name, value, important);
                    return;
                }
                catch (DOMException e) {
                    if (this.currentRule.getStyleDeclarationErrorHandler() == null) return;
                    CSSPropertyValueException ex = new CSSPropertyValueException(e);
                    ex.setValueText(value.toString());
                    this.currentRule.getStyleDeclarationErrorHandler().wrongValue(name, ex);
                }
            }
        }

        @Override
        public void endKeyframe() {
            this.setCommentsToRule(this.currentRule);
            this.lastRule = this.currentRule = null;
            this.setLexicalPropertyListener(null);
        }

        @Override
        public void comment(String text, boolean precededByLF) {
            if (this.lastRule != null && !precededByLF) {
                if (this.lastRule.getTrailingComments() == null) {
                    this.lastRule.setTrailingComments(new LinkedStringList());
                }
                this.lastRule.getTrailingComments().add(text);
            } else if (this.currentRule == null) {
                if (this.comments == null) {
                    this.comments = new LinkedStringList();
                }
                this.comments.add(text);
            }
        }

        private void setCommentsToRule(AbstractCSSRule rule) {
            if (this.comments != null && !this.comments.isEmpty()) {
                LinkedStringList ruleComments = new LinkedStringList();
                ruleComments.addAll(this.comments);
                rule.setPrecedingComments(ruleComments);
            }
            this.resetCommentStack();
        }

        private void resetCommentStack() {
            if (this.comments != null) {
                this.comments.clear();
            }
        }
    }
}

