/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.storage;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public class StreamContentStorage
implements DBDContentStorage {
    private final InputStream stream;

    public StreamContentStorage(InputStream stream) {
        this.stream = stream;
    }

    @Override
    public InputStream getContentStream() throws IOException {
        return this.stream;
    }

    @Override
    public Reader getContentReader() throws IOException {
        return new InputStreamReader(this.stream, this.getCharset());
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getCharset() {
        return GeneralUtils.DEFAULT_ENCODING;
    }

    @Override
    public DBDContentStorage cloneStorage(DBRProgressMonitor monitor) throws IOException {
        return new StreamContentStorage(this.stream);
    }

    @Override
    public void release() {
        IOUtils.close((Closeable)this.stream);
    }
}

