﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/rekognition/Rekognition_EXPORTS.h>
#include <aws/rekognition/model/Face.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Rekognition {
namespace Model {
class ListFacesResult {
 public:
  AWS_REKOGNITION_API ListFacesResult() = default;
  AWS_REKOGNITION_API ListFacesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_REKOGNITION_API ListFacesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of <code>Face</code> objects. </p>
   */
  inline const Aws::Vector<Face>& GetFaces() const { return m_faces; }
  template <typename FacesT = Aws::Vector<Face>>
  void SetFaces(FacesT&& value) {
    m_facesHasBeenSet = true;
    m_faces = std::forward<FacesT>(value);
  }
  template <typename FacesT = Aws::Vector<Face>>
  ListFacesResult& WithFaces(FacesT&& value) {
    SetFaces(std::forward<FacesT>(value));
    return *this;
  }
  template <typename FacesT = Face>
  ListFacesResult& AddFaces(FacesT&& value) {
    m_facesHasBeenSet = true;
    m_faces.emplace_back(std::forward<FacesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the response is truncated, Amazon Rekognition returns this token that you
   * can use in the subsequent request to retrieve the next set of faces.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListFacesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Version number of the face detection model associated with the input
   * collection (<code>CollectionId</code>).</p>
   */
  inline const Aws::String& GetFaceModelVersion() const { return m_faceModelVersion; }
  template <typename FaceModelVersionT = Aws::String>
  void SetFaceModelVersion(FaceModelVersionT&& value) {
    m_faceModelVersionHasBeenSet = true;
    m_faceModelVersion = std::forward<FaceModelVersionT>(value);
  }
  template <typename FaceModelVersionT = Aws::String>
  ListFacesResult& WithFaceModelVersion(FaceModelVersionT&& value) {
    SetFaceModelVersion(std::forward<FaceModelVersionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListFacesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Face> m_faces;
  bool m_facesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_faceModelVersion;
  bool m_faceModelVersionHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
