/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import us.fatehi.utility.ProcessExecutor;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.FileContents;
import us.fatehi.utility.string.StringFormat;

public final class GraphvizUtility {
    private static final Logger LOGGER = Logger.getLogger(GraphvizUtility.class.getName());
    private static final String SC_GRAPHVIZ_PROC_DISABLE = "SC_GRAPHVIZ_PROC_DISABLE";

    public static boolean isGraphvizAvailable() {
        Integer exitCode;
        boolean disableGraphviz = Boolean.valueOf(PropertiesUtility.getSystemConfigurationProperty((String)SC_GRAPHVIZ_PROC_DISABLE, (String)"false"));
        if (disableGraphviz) {
            LOGGER.log(Level.CONFIG, "Not creating a native process for Grahviz, since this is disabled");
            return false;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        command.add("-V");
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Checking if Graphviz is available:%n%s", new Object[]{((Object)command).toString()}));
        ProcessExecutor processExecutor = new ProcessExecutor();
        processExecutor.setCommandLine(command);
        try {
            exitCode = processExecutor.call();
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Graphviz stdout:%n%s", new Object[]{new FileContents(processExecutor.getProcessOutput())}));
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Graphviz stderr:%n%s", new Object[]{new FileContents(processExecutor.getProcessError())}));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not execute Graphviz command", e);
            LOGGER.log(Level.WARNING, (Supplier<String>)new StringFormat("Graphviz stderr:%n%s", new Object[]{new FileContents(processExecutor.getProcessError())}));
            exitCode = Integer.MIN_VALUE;
        }
        boolean successful = exitCode != null && exitCode == 0;
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Checking if diagram can be generated with Graphviz - \n is Graphviz installed? = <%s>", new Object[]{successful}));
        return successful;
    }

    public static boolean isGraphvizJavaAvailable(DiagramOutputFormat diagramOutputFormat) {
        String className = "guru.nidi.graphviz.engine.Graphviz";
        boolean hasClass = Utility.isClassAvailable((String)"guru.nidi.graphviz.engine.Graphviz");
        boolean supportsFormat = EnumSet.of(DiagramOutputFormat.svg, DiagramOutputFormat.png, DiagramOutputFormat.ps, DiagramOutputFormat.xdot, DiagramOutputFormat.plain).contains((Object)diagramOutputFormat);
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Checking if diagram can be generated with the Graphviz Java library - \n can load <%s>? = <%b>, \n can generate format <%s>? = <%b>", new Object[]{"guru.nidi.graphviz.engine.Graphviz", hasClass, diagramOutputFormat.getDescription(), supportsFormat}));
        return hasClass && supportsFormat;
    }

    private GraphvizUtility() {
    }
}

