/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.Query;
import com.amazon.redshift.core.ResultCursor;
import com.amazon.redshift.core.ResultHandler;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.v3.RedshiftRowsBlockingQueue;
import com.amazon.redshift.jdbc.RedshiftWarningWrapper;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Properties;

public class ResultHandlerBase
implements ResultHandler {
    private SQLException firstException;
    private SQLException lastException;
    private RedshiftWarningWrapper warningChain;
    Properties props;

    public ResultHandlerBase(Properties inProps) {
        this.props = inProps;
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor, RedshiftRowsBlockingQueue<Tuple> queueTuples, int[] rowCount, Thread ringBufferThread) {
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
    }

    @Override
    public void secureProgress() {
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        if (this.warningChain == null) {
            this.warningChain = new RedshiftWarningWrapper(warning, this.props);
        } else {
            this.warningChain.appendWarning(warning);
        }
    }

    @Override
    public void handleError(SQLException error) {
        if (this.firstException == null) {
            this.firstException = this.lastException = error;
            return;
        }
        this.lastException.setNextException(error);
        this.lastException = error;
    }

    @Override
    public void handleCompletion() throws SQLException {
        if (this.firstException != null) {
            throw this.firstException;
        }
    }

    @Override
    public SQLException getException() {
        return this.firstException;
    }

    @Override
    public SQLWarning getWarning() {
        if (this.warningChain == null) {
            return null;
        }
        return this.warningChain.getFirstWarning();
    }

    @Override
    public void setStatementStateIdleFromInQuery() {
    }

    @Override
    public void setStatementStateInQueryFromIdle() {
    }

    @Override
    public boolean setStatementStateInQuerySuspendedFromInQuery() {
        return false;
    }

    @Override
    public boolean wantsScrollableResultSet() {
        return false;
    }
}

