/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.property;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;
import us.fatehi.utility.property.PropertyName;

public abstract class PropertyNameUtility {
    private static final Logger LOGGER = Logger.getLogger(PropertyNameUtility.class.getName());

    public static String tableOf(String title, Collection<PropertyName> propertyNames) {
        int index = 0;
        StringBuilder buffer = new StringBuilder(1024);
        try {
            int maxNameLength = 0;
            for (PropertyName registeredPlugin : propertyNames) {
                int length = registeredPlugin.getName().length();
                if (length <= maxNameLength) continue;
                maxNameLength = length;
            }
            String format = String.format("%%2d %%%ds %%s", maxNameLength);
            if (!Utility.isBlank(title)) {
                buffer.append(title).append(System.lineSeparator());
            }
            for (PropertyName registeredPlugin : propertyNames) {
                buffer.append(String.format(format, ++index, registeredPlugin.getName(), registeredPlugin.getDescription())).append(System.lineSeparator());
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.INFO, "Could not list " + title, e);
        }
        return buffer.toString();
    }

    private PropertyNameUtility() {
    }
}

