/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AzureCliCredential;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AzureCliCredentialBuilder
extends CredentialBuilderBase<AzureCliCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AzureCliCredentialBuilder.class);
    private String tenantId;

    public AzureCliCredentialBuilder tenantId(String tenantId) {
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        this.tenantId = tenantId;
        return this;
    }

    public AzureCliCredentialBuilder processTimeout(Duration processTimeout) {
        Objects.requireNonNull(processTimeout);
        this.identityClientOptions.setCredentialProcessTimeout(processTimeout);
        return this;
    }

    public AzureCliCredential build() {
        return new AzureCliCredential(this.tenantId, this.identityClientOptions);
    }

    public AzureCliCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants)));
        return this;
    }

    public AzureCliCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants));
        return this;
    }
}

