"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSwitch", {
  enumerable: true,
  get: function get() {
    return _switch.EuiSwitch;
  }
});
Object.defineProperty(exports, "EuiCompressedSwitch", {
  enumerable: true,
  get: function get() {
    return _switch.EuiCompressedSwitch;
  }
});
exports.OuiCompressedSwitch = exports.OuiSwitch = exports.DISPLAYS = exports.COLORS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../../common");
var _accessibility = require("../../../services/accessibility");
var _icon = require("../../icon");
var _switch = require("../../../eui_components/form/switch/switch");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var baseClassName = 'ouiSwitch';
var colorToClassNameMap = {
  primary: "".concat(baseClassName, "--primary"),
  accent: "".concat(baseClassName, "--accent"),
  secondary: "".concat(baseClassName, "--secondary"),
  success: "".concat(baseClassName, "--success"),
  warning: "".concat(baseClassName, "--warning"),
  danger: "".concat(baseClassName, "--danger"),
  ghost: "".concat(baseClassName, "--ghost"),
  text: "".concat(baseClassName, "--text")
};
var COLORS = (0, _common.keysOf)(colorToClassNameMap);
exports.COLORS = COLORS;
var displayToClassNameMap = {
  base: "".concat(baseClassName, "--base"),
  empty: null
};
var DISPLAYS = (0, _common.keysOf)(displayToClassNameMap);
exports.DISPLAYS = DISPLAYS;
var OuiSwitch = function OuiSwitch(_ref) {
  var label = _ref.label,
    id = _ref.id,
    checked = _ref.checked,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    onChange = _ref.onChange,
    className = _ref.className,
    _ref$showLabel = _ref.showLabel,
    showLabel = _ref$showLabel === void 0 ? true : _ref$showLabel,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    labelProps = _ref.labelProps,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'empty' : _ref$display,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["label", "id", "checked", "disabled", "compressed", "onChange", "className", "showLabel", "type", "labelProps", "color", "display"]);
  var _useState = (0, _react.useState)(id || (0, _accessibility.htmlIdGenerator)()()),
    _useState2 = (0, _slicedToArray2.default)(_useState, 1),
    switchId = _useState2[0];
  var _useState3 = (0, _react.useState)((labelProps === null || labelProps === void 0 ? void 0 : labelProps.id) || (0, _accessibility.htmlIdGenerator)()()),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 1),
    labelId = _useState4[0];
  var onClick = (0, _react.useCallback)(function (e) {
    if (disabled) {
      return;
    }
    var event = e;
    event.target.checked = !checked;
    onChange(event);
  }, [checked, disabled, onChange]);
  var classes = (0, _classnames.default)('ouiSwitch', color && colorToClassNameMap[color], display && displayToClassNameMap[display], {
    'ouiSwitch--compressed': compressed,
    'ouiSwitch-isDisabled': disabled
  }, className);
  var labelClasses = (0, _classnames.default)('ouiSwitch__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  if (showLabel === false && typeof label !== 'string') {
    console.warn('OuiSwitch `label` must be a string when `showLabel` is false.');
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: classes
  }, /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    id: switchId,
    "aria-checked": checked || false,
    className: "ouiSwitch__button",
    role: "switch",
    type: type,
    disabled: disabled,
    onClick: onClick,
    "aria-label": showLabel ? undefined : label,
    "aria-labelledby": showLabel ? labelId : undefined
  }, rest), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiSwitch__body"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiSwitch__thumb"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiSwitch__track"
  }, !compressed && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
    type: "cross",
    size: "m",
    className: "ouiSwitch__icon"
  }), /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
    type: "check",
    size: "m",
    className: "ouiSwitch__icon ouiSwitch__icon--checked"
  }))))), showLabel &&
  /*#__PURE__*/
  // <button> + <label> has poor screen reader support.
  // Click handler added to simulate natural, secondary <label> interactivity.
  // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
  _react.default.createElement("span", (0, _extends2.default)({}, labelProps, {
    className: labelClasses,
    id: labelId,
    onClick: onClick
  }), label));
};

// @internal
exports.OuiSwitch = OuiSwitch;
OuiSwitch.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  /**
       * Whether to render the text label
       */
  showLabel: _propTypes.default.bool,
  /**
       * Must be a string if `showLabel` prop is false
       */
  label: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.string.isRequired]).isRequired,
  checked: _propTypes.default.bool.isRequired,
  onChange: _propTypes.default.func.isRequired,
  /**
       * Any of the named color palette options.
       * **`subdued` set to be DEPRECATED, use `text` instead**
       */
  color: _propTypes.default.oneOf(["primary", "accent", "secondary", "success", "warning", "danger", "ghost", "text"]),
  disabled: _propTypes.default.bool,
  compressed: _propTypes.default.bool,
  type: _propTypes.default.oneOf(["submit", "reset", "button"]),
  /**
       * Object of props passed to the label's <span/>
       */
  labelProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }),
  /**
       * Sets the display style for matching other OuiButton types.
       * `base` is equivalent to a typical OuiButton
       * `empty` (default) is equivalent to an OuiButtonEmpty
       */
  display: _propTypes.default.oneOf(["base", "empty"])
};
// @internal
var OuiCompressedSwitch = function OuiCompressedSwitch(props) {
  return /*#__PURE__*/_react.default.createElement(OuiSwitch, (0, _extends2.default)({}, props, {
    compressed: true
  }));
};

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */
exports.OuiCompressedSwitch = OuiCompressedSwitch;