/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import com.google.common.collect.Sets;
import java.time.Clock;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.transport.SuggestName;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.Name;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.rest.handler.HistorySuggest;
import org.opensearch.timeseries.rest.handler.IntervalCalculation;
import org.opensearch.timeseries.rest.handler.LatestTimeRetriever;
import org.opensearch.timeseries.transport.SuggestConfigParamRequest;
import org.opensearch.timeseries.transport.SuggestConfigParamResponse;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public abstract class BaseSuggestConfigParamTransportAction
extends HandledTransportAction<SuggestConfigParamRequest, SuggestConfigParamResponse> {
    public static final Logger logger = LogManager.getLogger(BaseSuggestConfigParamTransportAction.class);
    protected final Client client;
    protected final SecurityClientUtil clientUtil;
    protected final SearchFeatureDao searchFeatureDao;
    protected volatile Boolean filterByEnabled;
    protected Clock clock;
    protected AnalysisType context;
    protected final Set<String> allSuggestParamStrs;
    private final Settings settings;

    public BaseSuggestConfigParamTransportAction(String actionName, Client client, SecurityClientUtil clientUtil, ClusterService clusterService, Settings settings, ActionFilters actionFilters, TransportService transportService, Setting<Boolean> filterByBackendRoleSetting, AnalysisType context, SearchFeatureDao searchFeatureDao) {
        super(actionName, transportService, actionFilters, SuggestConfigParamRequest::new);
        this.client = client;
        this.clientUtil = clientUtil;
        this.filterByEnabled = (Boolean)filterByBackendRoleSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(filterByBackendRoleSetting, it -> {
            this.filterByEnabled = it;
        });
        this.clock = Clock.systemUTC();
        this.context = context;
        this.searchFeatureDao = searchFeatureDao;
        List<SuggestName> allSuggestParams = Arrays.asList(SuggestName.values());
        this.allSuggestParamStrs = Name.getListStrs(allSuggestParams);
        this.settings = settings;
    }

    protected void doExecute(Task task, SuggestConfigParamRequest request, ActionListener<SuggestConfigParamResponse> listener) {
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.verifyResourceAccessAndProcessRequest(this.settings, args -> this.suggestExecute(request, user, context, listener), new Object[0], fallbackArgs -> this.resolveUserAndExecute(user, listener, () -> this.suggestExecute(request, user, context, listener)), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    public void resolveUserAndExecute(User requestedUser, ActionListener<SuggestConfigParamResponse> listener, ExecutorFunction function) {
        try {
            String error;
            if (this.filterByEnabled.booleanValue() && (error = ParseUtils.checkFilterByBackendRoles(requestedUser)) != null) {
                listener.onFailure((Exception)new TimeSeriesException(error));
                return;
            }
            function.execute();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected void suggestInterval(Config config, User user, TimeValue timeout, ActionListener<Pair<IntervalTimeConfiguration, Map<String, Object>>> listener) {
        LatestTimeRetriever latestTimeRetriever = new LatestTimeRetriever(config, timeout, this.clientUtil, this.client, user, this.context, this.searchFeatureDao, true);
        ActionListener latestTimeListener = ActionListener.wrap(latestEntityAttributes -> {
            Optional latestTime = (Optional)latestEntityAttributes.getLeft();
            if (latestTime.isPresent()) {
                IntervalCalculation intervalCalculation = new IntervalCalculation(config, timeout, this.client, this.clientUtil, user, this.context, this.clock, this.searchFeatureDao, (Long)latestTime.get(), (Map)latestEntityAttributes.getRight(), false);
                intervalCalculation.findInterval((ActionListener<IntervalTimeConfiguration>)ActionListener.wrap(interval -> listener.onResponse((Object)Pair.of((Object)interval, (Object)((Map)latestEntityAttributes.getRight()))), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onFailure((Exception)new TimeSeriesException("Empty data. Cannot find a good interval."));
            }
        }, exception -> {
            listener.onFailure(exception);
            logger.error("Failed to create search request for last data point", (Throwable)exception);
        });
        latestTimeRetriever.checkIfHC((ActionListener<Pair<Optional<Long>, Map<String, Object>>>)latestTimeListener);
    }

    protected void suggestHistory(Config config, User user, TimeValue timeout, boolean suggestInterval, ActionListener<SuggestConfigParamResponse> listener) {
        if (!suggestInterval && config.getInterval() != null) {
            IntervalTimeConfiguration interval = new IntervalTimeConfiguration(config.getIntervalInMinutes(), ChronoUnit.MINUTES);
            HistorySuggest historySuggest = new HistorySuggest(config, user, this.searchFeatureDao, interval, new HashMap<String, Object>(), this.clock);
            historySuggest.suggestHistory((ActionListener<SuggestConfigParamResponse>)ActionListener.wrap(historyResponse -> listener.onResponse((Object)new SuggestConfigParamResponse.Builder().history(historyResponse.getHistory()).interval(interval).build()), arg_0 -> listener.onFailure(arg_0)));
            return;
        }
        this.suggestInterval(config, user, timeout, (ActionListener<Pair<IntervalTimeConfiguration, Map<String, Object>>>)ActionListener.wrap(intervalEntity -> {
            HistorySuggest historySuggest = new HistorySuggest(config, user, this.searchFeatureDao, (IntervalTimeConfiguration)intervalEntity.getLeft(), (Map)intervalEntity.getRight(), this.clock);
            historySuggest.suggestHistory((ActionListener<SuggestConfigParamResponse>)ActionListener.wrap(historyResponse -> listener.onResponse((Object)new SuggestConfigParamResponse.Builder().history(historyResponse.getHistory()).interval((IntervalTimeConfiguration)intervalEntity.getLeft()).build()), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected void suggestWindowDelay(Config config, User user, TimeValue timeout, ActionListener<SuggestConfigParamResponse> listener) {
        LatestTimeRetriever latestTimeRetriever = new LatestTimeRetriever(config, timeout, this.clientUtil, this.client, user, this.context, this.searchFeatureDao, false);
        ActionListener latestTimeListener = ActionListener.wrap(latestEntityAttributes -> {
            Optional latestTime = (Optional)latestEntityAttributes.getLeft();
            if (latestTime.isPresent()) {
                long windowDelayMillis = 0L;
                long currentMillis = this.clock.millis();
                if (currentMillis > (Long)latestTime.get()) {
                    long gapMs = currentMillis - (Long)latestTime.get();
                    long bucketMs = config.getIntervalInMilliseconds();
                    long bucketsBehind = (gapMs + bucketMs - 1L) / bucketMs;
                    long safetyBuckets = 1L;
                    windowDelayMillis = (bucketsBehind + safetyBuckets) * bucketMs;
                }
                listener.onResponse((Object)new SuggestConfigParamResponse.Builder().windowDelay(new IntervalTimeConfiguration((long)Math.ceil((double)windowDelayMillis / 60000.0), ChronoUnit.MINUTES)).build());
            } else {
                listener.onFailure((Exception)new TimeSeriesException("Cannot find a good window delay."));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        latestTimeRetriever.checkIfHC((ActionListener<Pair<Optional<Long>, Map<String, Object>>>)latestTimeListener);
    }

    public abstract void suggestExecute(SuggestConfigParamRequest var1, User var2, ThreadContext.StoredContext var3, ActionListener<SuggestConfigParamResponse> var4);

    protected Set<SuggestName> getParametersToSuggest(String typesStr) {
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(typesStr.split(",")));
        return SuggestName.getNames((Collection<String>)Sets.intersection(this.allSuggestParamStrs, typesInRequest));
    }
}

